import { __decorate, __metadata } from "tslib";
import { action, computed, observable } from 'mobx';
import { QuestionnaireBusinessService } from '../services/QuestionnaireBusinessService';
import { getQuestionnaireLogin, saveQuestionnaireLogin, } from '../utils/storage';
export class QuestionnaireLoginStore {
    constructor() {
        this.questionnaireBusiness = {
            data: null,
            error: null,
            isLoading: false,
        };
        this.questionnaireUserResponse = {
            data: null,
            error: null,
            isLoading: false,
        };
        this.fetchUser = (emailId) => {
            this.setBusiness(true, null, null);
            this.setUser(true, null, null);
            QuestionnaireBusinessService.fetchUser(emailId)
                .then((result) => {
                var _a;
                this.setBusiness(false, null, result.privateBusiness);
                this.setUser(false, null, result.user);
                saveQuestionnaireLogin({
                    businessId: result.privateBusiness.id,
                    email: (_a = result.user.email) !== null && _a !== void 0 ? _a : '',
                });
            })
                .catch((error) => {
                this.setBusiness(false, error, null);
                this.setUser(false, error, null);
            });
        };
        this.updateUser = (emailId, user) => {
            this.setUser(true, null, null);
            QuestionnaireBusinessService.updateUser(emailId, user)
                .then((result) => {
                this.setUser(false, null, result);
            })
                .catch((error) => {
                this.setUser(false, error, null);
            });
        };
        this.setBusiness = (isLoading, error, value) => {
            this.questionnaireBusiness = {
                data: value,
                error,
                isLoading,
            };
        };
        this.clearBusiness = () => {
            this.setBusiness(false, false, null);
        };
        this.setUser = (isLoading, error, value) => {
            this.questionnaireUserResponse = {
                data: value,
                error,
                isLoading,
            };
        };
        this.clearUser = () => {
            this.setUser(false, false, null);
        };
    }
    get isLoggedIn() {
        // FIXME: [FIXTURES] this is temporary to work with business
        const businessIds = this.questionnaireBusiness.data;
        return businessIds !== null;
    }
    get businessId() {
        // FIXME: [FIXTURES] this is temporary to work with business
        const savedQuestionnaireLogin = getQuestionnaireLogin();
        const businessIds = savedQuestionnaireLogin === null || savedQuestionnaireLogin === void 0 ? void 0 : savedQuestionnaireLogin.businessId;
        // if (!businessIds) throw new Error('No Business Id');
        return businessIds !== null && businessIds !== void 0 ? businessIds : '';
    }
}
__decorate([
    observable,
    __metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "questionnaireBusiness", void 0);
__decorate([
    observable,
    __metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "questionnaireUserResponse", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "setBusiness", void 0);
__decorate([
    action,
    __metadata("design:type", Object)
], QuestionnaireLoginStore.prototype, "setUser", void 0);
__decorate([
    computed,
    __metadata("design:type", Boolean),
    __metadata("design:paramtypes", [])
], QuestionnaireLoginStore.prototype, "isLoggedIn", null);
__decorate([
    computed,
    __metadata("design:type", String),
    __metadata("design:paramtypes", [])
], QuestionnaireLoginStore.prototype, "businessId", null);
//# sourceMappingURL=QuestionnaireLoginStore.js.map