import React, { MouseEventHandler } from 'react';
export interface ClickHandlers {
    onMouseDown: MouseEventHandler;
    onMouseUp: MouseEventHandler;
    onMouseMove: MouseEventHandler;
}
export declare function getClickHandlers(clickFunction: MouseEventHandler, eventActions?: MouseEventHandler): ClickHandlers;
export declare function getRandomColor(): string;
export declare type ClassNameMapping = string | Record<string, boolean | undefined>;
export declare function classNames(...args: Array<ClassNameMapping>): string;
export declare function classNamesWithModules(styles: Record<string, string | undefined>): (...args: Array<ClassNameMapping>) => string;
export declare function debounce(func: Function, delay: number): Function;
export declare function htmlUnescape(str: string): string;
export declare function htmlEscape(str: string): string;
export declare function isMacintosh(): boolean;
export declare function getKeyCode(event: React.KeyboardEvent): number | undefined;
export declare function isValidURL(str: string): boolean;
export declare function startTimer(callback: (time: number) => void, interval: number): () => void;
export declare function validateEmail(email: string): boolean;
