export declare enum RequestMethod {
    GET = "GET",
    POST = "POST",
    DELETE = "DELETE",
    PUT = "PUT"
}
export declare type HTTPRequestInit = RequestInit & {
    parseJSON?: boolean;
};
declare type RequestInterceptor = (url: string, requestInit: RequestInit) => void;
declare type ResponseInterceptor = (data: object, status: number) => void;
declare type ErrorInterceptor = (response: Response) => void;
declare function addHeader(name: string, value: string): void;
declare function removeHeader(name: string): void;
declare function clearHeaders(): void;
declare function addRequestInterceptor(interceptor: RequestInterceptor): void;
declare function removeRequestInterceptor(interceptor: RequestInterceptor): void;
declare function clearRequestInterceptors(): void;
declare function addResponseInterceptor(interceptor: ResponseInterceptor): void;
declare function removeResponseInterceptor(interceptor: ResponseInterceptor): void;
declare function clearResponseInterceptors(): void;
declare function addErrorInterceptor(interceptor: ErrorInterceptor): void;
declare function removeErrorInterceptor(interceptor: ErrorInterceptor): void;
declare function clearErrorInterceptors(): void;
export declare function ajax<RequestType, ResponseType>(url: string, method: RequestMethod, requestBody?: RequestType, init?: HTTPRequestInit): Promise<ResponseType>;
export declare function get<ResponseType>(url: string, init?: HTTPRequestInit): Promise<ResponseType>;
export declare function post<ResponseType, RequestType>(url: string, requestBody?: RequestType, init?: HTTPRequestInit): Promise<ResponseType>;
export declare function deleteApi<ResponseType, RequestType>(url: string, requestBody?: RequestType, init?: HTTPRequestInit): Promise<ResponseType>;
export declare function put<ResponseType, RequestType>(url: string, requestBody?: RequestType, init?: HTTPRequestInit): Promise<ResponseType>;
export declare const http: {
    addHeader: typeof addHeader;
    removeHeader: typeof removeHeader;
    clearHeaders: typeof clearHeaders;
    addRequestInterceptor: typeof addRequestInterceptor;
    removeRequestInterceptor: typeof removeRequestInterceptor;
    clearRequestInterceptors: typeof clearRequestInterceptors;
    addResponseInterceptor: typeof addResponseInterceptor;
    removeResponseInterceptor: typeof removeResponseInterceptor;
    clearResponseInterceptors: typeof clearResponseInterceptors;
    addErrorInterceptor: typeof addErrorInterceptor;
    removeErrorInterceptor: typeof removeErrorInterceptor;
    clearErrorInterceptors: typeof clearErrorInterceptors;
    ajax: typeof ajax;
    get: typeof get;
    post: typeof post;
    delete: typeof deleteApi;
    put: typeof put;
};
export {};
