import { ComponentType } from 'react';
import { NetworkError, NetworkResponse } from '../models';
import { RootStore } from '../stores';
export declare function useStores<StoreType>(): StoreType;
export declare function useSelector<StoreType, ResultType>(selector: (a: StoreType) => ResultType): ResultType;
export declare const applyNetworkResponse: <Type>(store: NetworkResponse<Type>, isLoading: boolean, response: Type | null, error: NetworkError | null) => void;
export declare function applyNetworkResponseForPromise<Type>(store: NetworkResponse<Type>, promise: Promise<Type>, successAction?: (response: Type) => void, failureAction?: (error: NetworkError) => void): Promise<void>;
export declare function getDefaultNetworkResponse<Type>(): NetworkResponse<Type>;
export interface TypeWithRootStoreConstructor<ActualType> {
    new (rootStore: RootStore): ActualType;
}
export interface TypeWithRootEmptyConstructor<ActualType> {
    new (): ActualType;
}
export interface Destructible {
    destructor: () => void;
}
export declare function provideWithRootStore<StoreType, PropTypes>(StoreClass: TypeWithRootStoreConstructor<StoreType>, WrappedComponent: ComponentType<PropTypes>): ComponentType<PropTypes>;
export declare function provideStore<StoreType, PropTypes>(StoreClass: TypeWithRootEmptyConstructor<StoreType>, WrappedComponent: ComponentType<PropTypes>): ComponentType<PropTypes>;
