import { __awaiter } from "tslib";
import React, { useContext, useEffect, useState } from 'react';
import { MobXProviderContext, Provider, useObserver } from 'mobx-react';
import { runInAction } from 'mobx';
export function useStores() {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return useContext(MobXProviderContext);
}
export function useSelector(selector) {
    const rootStore = useStores();
    return useObserver(() => selector(rootStore));
}
export const applyNetworkResponse = function setNetworkResponse(store, isLoading, response, error) {
    runInAction(() => {
        store.isLoading = isLoading;
        store.data = response;
        store.error = error;
    });
};
export function applyNetworkResponseForPromise(store, promise, successAction, failureAction) {
    return __awaiter(this, void 0, void 0, function* () {
        applyNetworkResponse(store, true, null, null);
        try {
            const response = yield promise;
            applyNetworkResponse(store, false, response, null);
            if (successAction)
                successAction(response);
        }
        catch (error) {
            applyNetworkResponse(store, false, null, error);
            if (failureAction)
                failureAction(error);
        }
    });
}
export function getDefaultNetworkResponse() {
    return {
        data: null,
        error: null,
        isLoading: false,
    };
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function hasDestructor(store) {
    return store && store.destructor && typeof store.destructor === 'function';
}
export function provideWithRootStore(StoreClass, WrappedComponent) {
    return function MergedStoreProvider(props) {
        const rootStore = useStores();
        const [store, setStore] = useState();
        useEffect(() => {
            const _store = new StoreClass(rootStore);
            setStore(_store);
            return () => {
                if (hasDestructor(_store)) {
                    _store.destructor();
                }
            };
            /* eslint-disable-next-line react-hooks/exhaustive-deps */
        }, []);
        if (!store)
            return null;
        return (React.createElement(Provider, Object.assign({}, rootStore, store),
            React.createElement(WrappedComponent, Object.assign({}, props))));
    };
}
export function provideStore(StoreClass, WrappedComponent) {
    return function StoreProvider(props) {
        const [store, setStore] = useState();
        useEffect(() => {
            const _store = new StoreClass();
            setStore(_store);
            return () => {
                if (hasDestructor(_store)) {
                    _store.destructor();
                }
            };
            /* eslint-disable-next-line react-hooks/exhaustive-deps */
        }, []);
        if (!store)
            return null;
        return (React.createElement(Provider, Object.assign({}, store),
            React.createElement(WrappedComponent, Object.assign({}, props))));
    };
}
//# sourceMappingURL=store.js.map