export function getAudioRecorder() {
    return new Promise((resolve, reject) => {
        navigator.getUserMedia({ audio: true }, (stream) => {
            const mediaRecorder = new MediaRecorder(stream);
            const audioChunks = [];
            let isRecording = false;
            mediaRecorder.addEventListener('dataavailable', (event) => {
                audioChunks.push(event.data);
            });
            const start = () => {
                if (!isRecording) {
                    isRecording = true;
                    mediaRecorder.start();
                }
                else {
                    throw new Error('Already recording');
                }
            };
            function stop() {
                return new Promise((resolve) => {
                    const listener = () => {
                        const audioBlob = new Blob(audioChunks, { type: 'audio/wav' });
                        const audioUrl = URL.createObjectURL(audioBlob);
                        stream.getTracks().forEach((track) => track.stop());
                        resolve({ audioBlob, audioUrl });
                        mediaRecorder.removeEventListener('stop', listener);
                    };
                    mediaRecorder.addEventListener('stop', listener);
                    if (isRecording) {
                        isRecording = false;
                        mediaRecorder.stop();
                    }
                });
            }
            resolve({
                stop,
                start,
                get isRecording() {
                    return isRecording;
                },
            });
        }, (e) => reject(e));
    });
}
export var AudioRecorderError;
(function (AudioRecorderError) {
    AudioRecorderError[AudioRecorderError["NOT_SECURE_CONTEXT"] = 0] = "NOT_SECURE_CONTEXT";
    AudioRecorderError[AudioRecorderError["NOT_SUPPORTED"] = 1] = "NOT_SUPPORTED";
    AudioRecorderError[AudioRecorderError["PERMISSION_DENIED"] = 2] = "PERMISSION_DENIED";
    AudioRecorderError[AudioRecorderError["UNKNOWN"] = 3] = "UNKNOWN";
})(AudioRecorderError || (AudioRecorderError = {}));
// export function useAudioErrors(
//   setError: (value: AudioRecorderError | undefined) => void
// ) {
//   const permissionResultRef = useRef<PermissionStatus>();
//
//   useEffect(() => {
//     if (!window.isSecureContext) {
//       setError(AudioRecorderError.NOT_SECURE_CONTEXT);
//       return;
//     }
//     navigator.mediaDevices.enumerateDevices().then((devices) => {
//       const hasAudioInput = devices.some(
//         (device) => device.kind === 'audioinput'
//       );
//       // if (hasAudioInput) {
//       //   navigator.permissions
//       //     .query({ name: 'microphone' })
//       //     .then(function (result) {
//       //       permissionResult.current = result;
//       //       if (result.state === 'denied') {
//       //         setError(AudioRecorderError.PERMISSION_DENIED);
//       //       }
//       //       result.onchange = function () {
//       //         if (result.state === 'denied') {
//       //           setError(AudioRecorderError.PERMISSION_DENIED);
//       //         }
//       //       };
//       //     })
//       //     .catch(() => {
//       //       // this only works on chrome. Use it. In other browsers, ignore this
//       //     });
//       // } else {
//       //   setError(AudioRecorderError.NOT_SUPPORTED);
//       // }
//       setError(undefined);
//     });
//     const permissionRef = permissionResultRef.current;
//     return () => {
//       if (permissionRef) {
//         permissionRef.onchange = null;
//       }
//     };
//     // eslint-disable-next-line react-hooks/exhaustive-deps
//   }, []);
// }
//# sourceMappingURL=audio.js.map