export interface ImageRecordingData {
    imageBlob?: Blob;
    imageUrl?: string;
    imageDataURL?: string;
}
export interface ImageRecorder {
    capture: () => Promise<ImageRecordingData>;
    cancel: () => void;
    stream: MediaStream;
    isRecording: boolean;
}
export declare function getImageRecorder(preview: HTMLVideoElement): Promise<ImageRecorder>;
export declare enum ImageRecorderError {
    NOT_SECURE_CONTEXT = 0,
    NOT_SUPPORTED = 1,
    PERMISSION_DENIED = 2,
    UNKNOWN = 3
}
