export function getImageRecorder(preview) {
    return new Promise((resolve, reject) => {
        navigator.getUserMedia({ video: true }, (stream) => {
            preview.srcObject = stream;
            /* eslint-disable @typescript-eslint/no-explicit-any */
            preview.captureStream =
                preview.captureStream || preview.mozCaptureStream;
            /* eslint-enable @typescript-eslint/no-explicit-any */
            new Promise((resolve) => (preview.onplaying = resolve)).then(() => {
                /* eslint-disable @typescript-eslint/no-explicit-any */
                const stream = preview.captureStream();
                /* eslint-enable @typescript-eslint/no-explicit-any */
                const mediaRecorder = new MediaRecorder(stream);
                // const videoChunks: Blob[] = [];
                const isRecording = false;
                // mediaRecorder.addEventListener('dataavailable', (event) => {
                //   videoChunks.push(event.data);
                // });
                function capture() {
                    return new Promise((resolve) => {
                        const canvas = document.createElement('canvas');
                        canvas.width = preview.videoWidth;
                        canvas.height = preview.videoHeight;
                        const context = canvas.getContext('2d');
                        if (preview.videoWidth && preview.videoHeight && context) {
                            canvas.width = preview.videoWidth;
                            canvas.height = preview.videoHeight;
                            context.drawImage(preview, 0, 0, preview.videoWidth, preview.videoHeight);
                            canvas.toBlob((blob) => {
                                if (!blob) {
                                    reject();
                                    return;
                                }
                                resolve({
                                    imageBlob: blob,
                                    imageUrl: URL.createObjectURL(blob),
                                });
                                stream.getTracks().forEach((track) => track.stop());
                            });
                        }
                        else {
                            reject();
                            stream.getTracks().forEach((track) => track.stop());
                        }
                    });
                }
                function cancel() {
                    stream.getTracks().forEach((track) => track.stop());
                }
                resolve({
                    capture,
                    cancel,
                    stream,
                    get isRecording() {
                        return isRecording;
                    },
                });
            });
            /* eslint-enable @typescript-eslint/no-explicit-any */
        }, (e) => reject(e));
    });
}
export var ImageRecorderError;
(function (ImageRecorderError) {
    ImageRecorderError[ImageRecorderError["NOT_SECURE_CONTEXT"] = 0] = "NOT_SECURE_CONTEXT";
    ImageRecorderError[ImageRecorderError["NOT_SUPPORTED"] = 1] = "NOT_SUPPORTED";
    ImageRecorderError[ImageRecorderError["PERMISSION_DENIED"] = 2] = "PERMISSION_DENIED";
    ImageRecorderError[ImageRecorderError["UNKNOWN"] = 3] = "UNKNOWN";
})(ImageRecorderError || (ImageRecorderError = {}));
// export function useImagePermissions(
//   setError: (value: ImageRecorderError | undefined) => void
// ) {
//   const permissionResultRef = useRef<PermissionStatus>();
//   useEffect(() => {
//     if (!window.isSecureContext) {
//       setError(ImageRecorderError.NOT_SECURE_CONTEXT);
//       return;
//     }
//     navigator.mediaDevices.enumerateDevices().then((devices) => {
//       const hasAudioInput = devices.some(
//         (device) => device.kind === 'audioinput'
//       );
//       const hasImageInput = devices.some(
//         (device) => device.kind === 'videoinput'
//       );
//       if (hasAudioInput && hasImageInput) {
//         // navigator.permissions
//         //   .query({ name: 'camera' })
//         //   .then(function (result) {
//         //     videoPermissionResult.current = result;
//         //     if (result.state === 'denied') {
//         //       setError(VideoRecorderError.PERMISSION_DENIED);
//         //     }
//         //     result.onchange = function () {
//         //       if (result.state === 'denied') {
//         //         setError(VideoRecorderError.PERMISSION_DENIED);
//         //       }
//         //     };
//         //   })
//         //   .catch(() => {
//         //     // this only works on chrome. Use it. In other browsers, ignore this
//         //   });
//
//         setError(undefined);
//       } else {
//         setError(ImageRecorderError.NOT_SUPPORTED);
//       }
//     });
//     const permissionResult = permissionResultRef.current;
//     return () => {
//       if (permissionResult) {
//         permissionResult.onchange = null;
//       }
//     };
//     // eslint-disable-next-line react-hooks/exhaustive-deps
//   }, []);
// }
//# sourceMappingURL=image.js.map