export interface VideoRecordingData {
    videoBlob?: Blob;
    videoUrl?: string;
    videoExternalUrl?: string;
}
export interface VideoRecorder {
    stop: () => Promise<VideoRecordingData>;
    start: () => void;
    stream: MediaStream;
    isRecording: boolean;
}
export declare function getVideoRecorder(preview: HTMLVideoElement): Promise<VideoRecorder>;
export declare enum VideoRecorderError {
    NOT_SECURE_CONTEXT = 0,
    NOT_SUPPORTED = 1,
    PERMISSION_DENIED = 2,
    UNKNOWN = 3
}
