export function getVideoRecorder(preview) {
    return new Promise((resolve, reject) => {
        navigator.getUserMedia({ audio: true }, () => {
            navigator.getUserMedia({ video: true }, () => {
                navigator.getUserMedia({ audio: true, video: true }, (stream) => {
                    preview.srcObject = stream;
                    /* eslint-disable @typescript-eslint/no-explicit-any */
                    // (preview as any).captureStream =
                    //   (preview as any).captureStream || (preview as any).mozCaptureStream;
                    /* eslint-enable @typescript-eslint/no-explicit-any */
                    new Promise((resolve) => (preview.onplaying = resolve)).then(() => {
                        /* eslint-disable @typescript-eslint/no-explicit-any */
                        // const stream = (preview as any).captureStream() as MediaStream;
                        /* eslint-enable @typescript-eslint/no-explicit-any */
                        const mediaRecorder = new MediaRecorder(stream);
                        const videoChunks = [];
                        let isRecording = false;
                        mediaRecorder.addEventListener('dataavailable', (event) => {
                            videoChunks.push(event.data);
                        });
                        const start = () => {
                            if (!isRecording) {
                                isRecording = true;
                                mediaRecorder.start();
                            }
                            else {
                                throw new Error('Already recording');
                            }
                        };
                        function stop() {
                            return new Promise((resolve) => {
                                const listener = () => {
                                    const videoBlob = new Blob(videoChunks, {
                                        type: 'video/webm',
                                    });
                                    const videoUrl = URL.createObjectURL(videoBlob);
                                    stream.getTracks().forEach((track) => track.stop());
                                    resolve({ videoBlob, videoUrl });
                                    mediaRecorder.removeEventListener('stop', listener);
                                };
                                mediaRecorder.addEventListener('stop', listener);
                                if (isRecording) {
                                    isRecording = false;
                                    mediaRecorder.stop();
                                }
                            });
                        }
                        resolve({
                            stop,
                            start,
                            stream,
                            get isRecording() {
                                return isRecording;
                            },
                        });
                    });
                    /* eslint-enable @typescript-eslint/no-explicit-any */
                }, (e) => reject(e));
            }, (e) => reject(e));
        }, (e) => reject(e));
    });
}
export var VideoRecorderError;
(function (VideoRecorderError) {
    VideoRecorderError[VideoRecorderError["NOT_SECURE_CONTEXT"] = 0] = "NOT_SECURE_CONTEXT";
    VideoRecorderError[VideoRecorderError["NOT_SUPPORTED"] = 1] = "NOT_SUPPORTED";
    VideoRecorderError[VideoRecorderError["PERMISSION_DENIED"] = 2] = "PERMISSION_DENIED";
    VideoRecorderError[VideoRecorderError["UNKNOWN"] = 3] = "UNKNOWN";
})(VideoRecorderError || (VideoRecorderError = {}));
// export function useVideoPermissions(
//   setError: (value: VideoRecorderError | undefined) => void
// ) {
//   const audioPermissionResultRef = useRef<PermissionStatus>();
//   const videoPermissionResultRef = useRef<PermissionStatus>();
//   useEffect(() => {
//     if (!window.isSecureContext) {
//       setError(VideoRecorderError.NOT_SECURE_CONTEXT);
//       return;
//     }
//     navigator.mediaDevices.enumerateDevices().then((devices) => {
//       const hasAudioInput = devices.some(
//         (device) => device.kind === 'audioinput'
//       );
//       const hasVideoInput = devices.some(
//         (device) => device.kind === 'videoinput'
//       );
//       if (hasAudioInput && hasVideoInput) {
//         // navigator.permissions
//         //   .query({ name: 'microphone' })
//         //   .then(function (result) {
//         //     audioPermissionResult.current = result;
//         //     if (result.state === 'denied') {
//         //       setError(VideoRecorderError.PERMISSION_DENIED);
//         //     }
//         //     result.onchange = function () {
//         //       if (result.state === 'denied') {
//         //         setError(VideoRecorderError.PERMISSION_DENIED);
//         //       }
//         //     };
//         //   })
//         //   .catch(() => {
//         //     // this only works on chrome. Use it. In other browsers, ignore this
//         //   });
//         // navigator.permissions
//         //   .query({ name: 'camera' })
//         //   .then(function (result) {
//         //     videoPermissionResult.current = result;
//         //     if (result.state === 'denied') {
//         //       setError(VideoRecorderError.PERMISSION_DENIED);
//         //     }
//         //     result.onchange = function () {
//         //       if (result.state === 'denied') {
//         //         setError(VideoRecorderError.PERMISSION_DENIED);
//         //       }
//         //     };
//         //   })
//         //   .catch(() => {
//         //     // this only works on chrome. Use it. In other browsers, ignore this
//         //   });
//         setError(undefined);
//       } else {
//         setError(VideoRecorderError.NOT_SUPPORTED);
//       }
//     });
//     const audioPermissionResult = audioPermissionResultRef.current;
//     const videoPermissionResult = videoPermissionResultRef.current;
//     return () => {
//       if (audioPermissionResult) {
//         audioPermissionResult.onchange = null;
//       }
//       if (videoPermissionResult) {
//         videoPermissionResult.onchange = null;
//       }
//     };
//     // eslint-disable-next-line react-hooks/exhaustive-deps
//   }, []);
// }
//# sourceMappingURL=video.js.map