"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthenticatedRoute = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const react_router_dom_1 = require("react-router-dom");
const utils_1 = require("../../utils");
function isRenderFunction(value) {
    return typeof value === 'function';
}
exports.AuthenticatedRoute = (props) => {
    const { location, component, render, children, path, exact, sensitive, strict, needsAuth, loginRoute, defaultRoute, } = props;
    const routerLocation = react_router_dom_1.useLocation();
    const redirectPath = react_1.useMemo(() => {
        const encodedRedirectPath = new URLSearchParams(routerLocation.search).get('redirectPath');
        return encodedRedirectPath && decodeURIComponent(encodedRedirectPath);
    }, [routerLocation.search]);
    const isLoggedIn = utils_1.useSelector((rootStore) => {
        return rootStore.loginStore.isLoggedIn;
    });
    const actualRender = react_1.useCallback((routeComponentProps) => {
        if (children) {
            if (isRenderFunction(children)) {
                return children(routeComponentProps);
            }
            else if (!Array.isArray(children) || children.length > 0) {
                return children;
            }
        }
        if (component) {
            return react_1.createElement(component, routeComponentProps);
        }
        if (render) {
            return render(routeComponentProps);
        }
        return null;
    }, [children, component, render]);
    const routerProps = react_1.useMemo(() => {
        return {
            location,
            path,
            exact,
            sensitive,
            strict,
        };
    }, [exact, location, path, sensitive, strict]);
    const currentPath = encodeURIComponent(routerLocation.pathname + routerLocation.hash + routerLocation.search);
    if (needsAuth && !isLoggedIn) {
        return react_1.default.createElement(react_router_dom_1.Redirect, { to: `${loginRoute}?redirectPath=${currentPath}` });
    }
    else if (routerLocation.pathname === loginRoute && isLoggedIn) {
        return react_1.default.createElement(react_router_dom_1.Redirect, { to: redirectPath || defaultRoute });
    }
    return react_1.default.createElement(react_router_dom_1.Route, Object.assign({}, routerProps, { render: actualRender }));
};
//# sourceMappingURL=AuthenticatedRoute.js.map