"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConditionBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const Expression_1 = require("./utils/Expression");
const utils_1 = require("./utils/utils");
const GroupBuilder_1 = require("./GroupBuilder");
const Config_1 = require("./utils/Config");
const hooks_1 = require("../../hooks");
const ConditionBuilderVariable_1 = require("./ConditionBuilderVariable");
exports.ConditionBuilder = (props) => {
    const { onConditionChange, onSanitizedConditionChanged, condition: conditionProp, variables, onDelete, } = props;
    const firstTime = react_1.useRef(true);
    const actualVariables = react_1.useMemo(() => {
        return variables
            .filter((it) => it.variableType !== ConditionBuilderVariable_1.ConditionBuilderVariableType.IMAGE &&
            it.variableType !== ConditionBuilderVariable_1.ConditionBuilderVariableType.VIDEO)
            .map((it) => {
            return Object.assign(Object.assign({}, it), { variableName: '$' + it.variableName });
        });
    }, [variables]);
    const [actualExpression, setExpression] = react_1.useState(() => {
        return utils_1.convertConditionToExpression(conditionProp, actualVariables);
    });
    const expression = hooks_1.useDebouncedValue(actualExpression, 500);
    const condition = react_1.useMemo(() => {
        return utils_1.getExpressionCondition(expression);
    }, [expression]);
    react_1.useEffect(() => {
        if (conditionProp !== condition && !firstTime.current) {
            const exp = utils_1.convertConditionToExpression(conditionProp, actualVariables);
            setExpression(exp);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [conditionProp]);
    const isExpressionValid = react_1.useMemo(() => {
        return !condition.includes(Config_1.BLANK_MARKER) && utils_1.validateExpression(expression);
    }, [condition, expression]);
    react_1.useEffect(() => {
        if (conditionProp !== condition) {
            onConditionChange(condition, isExpressionValid);
        }
        if (onSanitizedConditionChanged) {
            const conditionHTML = utils_1.sanitizeExpression(expression, actualVariables);
            onSanitizedConditionChanged(conditionHTML);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [condition]);
    react_1.useEffect(() => {
        onConditionChange(condition, isExpressionValid);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [isExpressionValid]);
    react_1.useEffect(() => {
        firstTime.current = false;
    }, []);
    function onExpressionChange(expression) {
        if (!expression || expression.type !== Expression_1.ExpressionType.GROUP) {
            return;
        }
        setExpression(expression);
    }
    return (react_1.default.createElement("div", { className: 'flex flex-col gap-4 flex-grow' },
        variables.length === 0 && (react_1.default.createElement("span", null, "No variables available to build conditional")),
        variables.length > 0 && (react_1.default.createElement(GroupBuilder_1.GroupBuilder, { expression: actualExpression, onChange: onExpressionChange, isDeleteEnabled: onDelete ? true : false, deleteGroup: onDelete, variables: actualVariables }))));
};
var Config_2 = require("./utils/Config");
Object.defineProperty(exports, "VariableType", { enumerable: true, get: function () { return Config_2.VariableType; } });
var utils_2 = require("./utils/utils");
Object.defineProperty(exports, "convertConditionToHTML", { enumerable: true, get: function () { return utils_2.convertConditionToHTML; } });
//# sourceMappingURL=ConditionBuilder.js.map