"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const Expression_1 = require("./utils/Expression");
const core_1 = require("@material-ui/core");
const Config_1 = require("./utils/Config");
const utils_1 = require("./utils/utils");
const icons_1 = require("@material-ui/icons");
const RuleBuilder_1 = require("./RuleBuilder");
const styles_1 = require("@material-ui/core/styles");
const useClasses = styles_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
const GroupBuilder = (props) => {
    const { expression, onChange, deleteGroup, isDeleteEnabled, variables, } = props;
    const classes = useClasses();
    if (expression === null) {
        return null;
    }
    function onConjunctionChange(event) {
        const conjunction = event.target.value;
        onChange(Object.assign(Object.assign({}, expression), { conjunction }));
    }
    function onAddRule() {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: [...expression.subExpressions, utils_1.getEmptyRule()] }));
    }
    function onAddGroup() {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: [...expression.subExpressions, utils_1.getEmptyGroup()] }));
    }
    function onDelete() {
        if (isDeleteEnabled) {
            deleteGroup === null || deleteGroup === void 0 ? void 0 : deleteGroup();
        }
    }
    function onSubExpressionChange(index, subExpression) {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: expression.subExpressions.map((item, itemIndex) => {
                if (index === itemIndex) {
                    return subExpression;
                }
                return item;
            }) }));
    }
    function onSubExpressionDelete(index) {
        onChange(Object.assign(Object.assign({}, expression), { subExpressions: expression.subExpressions.filter((item, itemIndex) => {
                return itemIndex !== index;
            }) }));
    }
    const groupConfig = Config_1.ConjunctionConfigMap[expression.conjunction];
    const isAddAllowed = expression.subExpressions.length < groupConfig.maxExpressions;
    return (react_1.default.createElement("div", { className: 'flex flex-col border border-gray-300 rounded-md' },
        react_1.default.createElement("div", { className: 'flex gap-4 p-4 bg-gray-100 rounded-md items-center' },
            react_1.default.createElement(core_1.Button, { variant: 'contained', disabled: !isAddAllowed, onClick: onAddRule }, "Add Rule"),
            react_1.default.createElement(core_1.Button, { variant: 'contained', disabled: !isAddAllowed, onClick: onAddGroup }, "Add Group"),
            react_1.default.createElement(core_1.Select, { variant: 'outlined', value: expression.conjunction, onChange: onConjunctionChange, inputProps: { className: classes.selectInput } }, Object.keys(Config_1.Conjunction).map((item) => {
                const conjunction = item;
                return (react_1.default.createElement(core_1.MenuItem, { key: conjunction, value: conjunction }, Config_1.ConjunctionConfigMap[conjunction].label));
            })),
            react_1.default.createElement("span", { className: 'flex-grow min-w-0' }),
            isDeleteEnabled && (react_1.default.createElement(core_1.Button, { variant: 'contained', onClick: onDelete },
                react_1.default.createElement(icons_1.Delete, null)))),
        expression.subExpressions.length > 0 && (react_1.default.createElement("div", { className: 'flex gap-4 flex-col p-4' }, expression.subExpressions.map((it, index) => {
            if ((it === null || it === void 0 ? void 0 : it.type) === Expression_1.ExpressionType.GROUP) {
                return (react_1.default.createElement(GroupBuilder, { key: index, expression: it, onChange: onSubExpressionChange.bind(undefined, index), isDeleteEnabled: true, deleteGroup: onSubExpressionDelete.bind(undefined, index), variables: variables }));
            }
            if ((it === null || it === void 0 ? void 0 : it.type) === Expression_1.ExpressionType.RULE) {
                return (react_1.default.createElement(RuleBuilder_1.RuleBuilder, { key: index, expression: it, onChange: onSubExpressionChange.bind(undefined, index), isDeleteEnabled: true, deleteRule: onSubExpressionDelete.bind(undefined, index), variables: variables }));
            }
            return react_1.default.createElement(react_1.Fragment, { key: index }, null);
        })))));
};
const MemoizedGroupBuilder = react_1.default.memo(GroupBuilder);
exports.GroupBuilder = MemoizedGroupBuilder;
//# sourceMappingURL=GroupBuilder.js.map