"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuleBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const RulePartBuilder_1 = require("./RulePartBuilder");
const utils_1 = require("./utils/utils");
const RuleBuilder = (props) => {
    const { expression, isDeleteEnabled, deleteRule, onChange, variables, } = props;
    function onDelete() {
        if (isDeleteEnabled) {
            deleteRule === null || deleteRule === void 0 ? void 0 : deleteRule();
        }
    }
    function onRulePartChange(index, part) {
        const newParts = expression.parts.slice(0, index);
        newParts.push(part);
        const newRule = Object.assign(Object.assign({}, expression), { parts: newParts });
        const addedParts = utils_1.getNextRuleParts(newRule, variables);
        newRule.parts = newRule.parts.concat(addedParts);
        onChange(newRule);
    }
    return (react_1.default.createElement("div", { className: 'flex p-4 gap-4 bg-green-100 rounded-md border ' +
            'border-gray-300 items-center' },
        react_1.default.createElement("span", { className: 'flex-grow min-w-0 flex gap-4 flex-wrap items-center' }, expression.parts.map((part, index) => {
            return (react_1.default.createElement(RulePartBuilder_1.RulePartBuilder, { key: index, rule: expression, partIndex: index, variables: variables, onChange: onRulePartChange }));
        })),
        isDeleteEnabled && (react_1.default.createElement(core_1.Button, { variant: 'contained', onClick: onDelete },
            react_1.default.createElement(icons_1.Delete, null)))));
};
const MemoizedRuleBuilder = react_1.default.memo(RuleBuilder);
exports.RuleBuilder = MemoizedRuleBuilder;
//# sourceMappingURL=RuleBuilder.js.map