"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RulePartBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const RulePart_1 = require("./utils/RulePart");
const VariableBuilder_1 = require("./part-builders/VariableBuilder");
const OperatorBuilder_1 = require("./part-builders/OperatorBuilder");
const LiteralBuilder_1 = require("./part-builders/LiteralBuilder");
exports.RulePartBuilder = (props) => {
    const { rule, onChange, partIndex, variables } = props;
    const part = rule.parts[partIndex];
    switch (part.type) {
        case RulePart_1.RulePartType.VARIABLE:
            return (react_1.default.createElement(VariableBuilder_1.VariableBuilder, { rule: rule, partIndex: partIndex, onChange: onChange, variables: variables }));
        case RulePart_1.RulePartType.OPERATOR:
            return (react_1.default.createElement(OperatorBuilder_1.OperatorBuilder, { rule: rule, partIndex: partIndex, onChange: onChange }));
        case RulePart_1.RulePartType.LITERAL:
            return (react_1.default.createElement(LiteralBuilder_1.LiteralBuilder, { rule: rule, partIndex: partIndex, onChange: onChange }));
    }
};
//# sourceMappingURL=RulePartBuilder.js.map