"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LiteralBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const RulePart_1 = require("../utils/RulePart");
const core_1 = require("@material-ui/core");
const styles_1 = require("@material-ui/core/styles");
const pickers_1 = require("@material-ui/pickers");
const DateRangeBuilder_1 = require("./literal-builders/DateRangeBuilder");
const icons_1 = require("@material-ui/icons");
const utils_1 = require("../../../utils");
const ConditionBuilderVariable_1 = require("../ConditionBuilderVariable");
const Config_1 = require("../utils/Config");
const RankingBuilder_1 = require("./literal-builders/RankingBuilder");
const useClasses = styles_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
exports.LiteralBuilder = (props) => {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q;
    const classes = useClasses();
    const { rule, partIndex, onChange } = props;
    const part = rule.parts[partIndex];
    function onChanged(value) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value }));
    }
    const suggestions = react_1.useMemo(() => {
        if (!part.suggestions) {
            return undefined;
        }
        if (utils_1.isStringArray(part.suggestions)) {
            return part.suggestions.map((it) => ({
                label: it,
                value: it,
            }));
        }
        return part.suggestions.map((it) => it);
    }, [part.suggestions]);
    if (suggestions &&
        part.variableType === ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY_RANKING) {
        return (react_1.default.createElement(RankingBuilder_1.RankingBuilder, { rule: rule, partIndex: partIndex, onChange: onChange }));
    }
    if (suggestions &&
        rule.parts[1].type === RulePart_1.RulePartType.OPERATOR && ((_a = rule.parts[1].variable) === null || _a === void 0 ? void 0 : _a.isCorrectableNodeType)) {
        if (rule.parts[1].value === Config_1.Operator.EQUALS ||
            rule.parts[1].value === Config_1.Operator.NOT_EQUALS) {
            return (react_1.default.createElement(core_1.Select, { value: part.value ? `${part.value}` : '', variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) },
                react_1.default.createElement(core_1.ListSubheader, null, "Options"),
                suggestions.map((it) => (react_1.default.createElement(core_1.MenuItem, { key: it.value, value: it.value }, it.label))),
                react_1.default.createElement(core_1.ListSubheader, null, "Truth Value"),
                react_1.default.createElement(core_1.MenuItem, { key: 'True', value: 'True' }, "True"),
                react_1.default.createElement(core_1.MenuItem, { key: 'False', value: 'False' }, "False")));
        }
        if (rule.parts[1].value === Config_1.Operator.EXACTMATCH ||
            rule.parts[1].value === Config_1.Operator.NOT_EXACTMATCH) {
            return (react_1.default.createElement(core_1.Select, { value: part.value ? part.value : [], variant: 'outlined', multiple: true, MenuProps: { getContentAnchorEl: null }, inputProps: { classNasme: classes.selectInput }, onChange: (event) => {
                    var _a;
                    const previousValue = (_a = part.value) !== null && _a !== void 0 ? _a : [];
                    if (previousValue.includes('True') ||
                        previousValue.includes('False')) {
                        onChanged(event.target.value.filter((value) => !previousValue.includes(value)));
                        return;
                    }
                    if (event.target.value.includes('True')) {
                        onChanged(['True']);
                    }
                    else if (event.target.value.includes('False')) {
                        onChanged(['False']);
                    }
                    else {
                        onChanged(event.target.value);
                    }
                } },
                react_1.default.createElement(core_1.ListSubheader, null, "Options"),
                suggestions.map((it) => (react_1.default.createElement(core_1.MenuItem, { key: it.value, value: it.value }, it.label))),
                react_1.default.createElement(core_1.ListSubheader, null, "Truth Value"),
                react_1.default.createElement(core_1.MenuItem, { key: 'True', value: 'True' }, "True"),
                react_1.default.createElement(core_1.MenuItem, { key: 'False', value: 'False' }, "False")));
        }
    }
    if (suggestions && !part.multiSelect) {
        return (react_1.default.createElement(core_1.Select, { value: part.value ? `${part.value}` : '', variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) }, suggestions.map((it) => (react_1.default.createElement(core_1.MenuItem, { key: it.value, value: it.value }, it.label)))));
    }
    if (suggestions && part.multiSelect) {
        return (react_1.default.createElement(core_1.Select, { value: part.value ? part.value : [], variant: 'outlined', multiple: true, MenuProps: { getContentAnchorEl: null }, inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) }, suggestions.map((it) => (react_1.default.createElement(core_1.MenuItem, { key: it.value, value: it.value }, it.label)))));
    }
    switch (part.literalType) {
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.STRING:
            return (react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_b = part.value) !== null && _b !== void 0 ? _b : '', onChange: (event) => onChanged(event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '')) }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.VIDEO:
            return (react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_c = part.value) !== null && _c !== void 0 ? _c : '', onChange: (event) => onChanged(event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '')) }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.IMAGE:
            return (react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_d = part.value) !== null && _d !== void 0 ? _d : '', onChange: (event) => onChanged(event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '')) }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.INTEGER:
            return (react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_e = part.value) !== null && _e !== void 0 ? _e : '', onChange: (event) => {
                    const matches = event.target.value.match(/^-?([1-9]?|[1-9][0-9]*)$/);
                    if (!matches) {
                        return;
                    }
                    onChanged(event.target.value);
                } }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.REAL:
            return (react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_f = part.value) !== null && _f !== void 0 ? _f : '', onChange: (event) => {
                    const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                    if (!matches) {
                        return;
                    }
                    onChanged(event.target.value);
                } }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.BOOLEAN:
            return (react_1.default.createElement(core_1.Select, { value: part.value ? `${part.value}` : '', variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(event.target.value) },
                react_1.default.createElement(core_1.MenuItem, { value: 'true' }, "Yes"),
                react_1.default.createElement(core_1.MenuItem, { value: 'false' }, "No")));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE:
            return (react_1.default.createElement(pickers_1.DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                    classes: { input: classes.selectInput },
                }, format: 'dd/MM/yyyy', value: (_g = part.value) !== null && _g !== void 0 ? _g : null, onChange: (date) => onChanged(date !== null && date !== void 0 ? date : undefined) }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.TIME:
            return (react_1.default.createElement(pickers_1.TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                    classes: { input: classes.selectInput },
                }, format: 'HH:mm', value: (_h = part.value) !== null && _h !== void 0 ? _h : null, onChange: (date) => onChanged(date !== null && date !== void 0 ? date : undefined) }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE_TIME:
            return (react_1.default.createElement(pickers_1.DateTimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                    classes: { input: classes.selectInput },
                }, format: 'dd/MM/yyyy HH:mm', value: (_j = part.value) !== null && _j !== void 0 ? _j : null, onChange: (date) => onChanged(date !== null && date !== void 0 ? date : undefined) }));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY:
            break;
        case 'DATE_RANGE':
            return react_1.default.createElement(DateRangeBuilder_1.DateRangeBuilder, Object.assign({}, props));
        case 'RANGE':
            // eslint-disable-next-line
            const value = ((_k = part.value) !== null && _k !== void 0 ? _k : { min: '', max: '', type: 'range' });
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_l = value.min) !== null && _l !== void 0 ? _l : '', onChange: (event) => {
                        const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                        if (!matches) {
                            return;
                        }
                        onChanged(Object.assign(Object.assign({}, value), { min: event.target.value }));
                    } }),
                react_1.default.createElement("span", { className: 'flex items-center' }, "-"),
                react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: { className: classes.selectInput }, value: (_m = value.max) !== null && _m !== void 0 ? _m : '', onChange: (event) => {
                        const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                        if (!matches) {
                            return;
                        }
                        onChanged(Object.assign(Object.assign({}, value), { max: event.target.value }));
                    } })));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_STRING: {
            const listVal = ((_o = part.value) !== null && _o !== void 0 ? _o : []);
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                listVal.map((value, fieldIndex) => {
                    var _a;
                    return (react_1.default.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        react_1.default.createElement(core_1.TextField, { variant: 'outlined', inputProps: {
                                className: classes.selectInput,
                            }, value: (_a = listVal[fieldIndex]) !== null && _a !== void 0 ? _a : '', key: fieldIndex, onChange: (event) => onChanged(listVal.map((it, index) => {
                                if (index === fieldIndex) {
                                    return event.target.value.replace(/[^\-_0-9a-zA-Z @.]/g, '');
                                }
                                return it;
                            })) }),
                        react_1.default.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onChanged(listVal.filter((it, index) => index !== fieldIndex)) },
                            react_1.default.createElement(icons_1.Close, null)),
                        fieldIndex !== listVal.length - 1 && (react_1.default.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                react_1.default.createElement(core_1.Button, { onClick: () => {
                        onChanged([...listVal, '']);
                    }, variant: 'contained' },
                    react_1.default.createElement(icons_1.Add, null)),
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "]")));
        }
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_INTEGER: {
            const listVal = ((_p = part.value) !== null && _p !== void 0 ? _p : []);
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                listVal.map((value, fieldIndex) => {
                    var _a;
                    return (react_1.default.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        react_1.default.createElement(core_1.TextField, { variant: 'outlined', key: fieldIndex, inputProps: {
                                className: classes.selectInput,
                            }, value: (_a = listVal[fieldIndex]) !== null && _a !== void 0 ? _a : '', onChange: (event) => {
                                const matches = event.target.value.match(/^-?([1-9]?|[1-9][0-9]*)$/);
                                if (!matches) {
                                    return;
                                }
                                onChanged(listVal.map((it, index) => {
                                    if (index === fieldIndex) {
                                        return event.target.value;
                                    }
                                    return it;
                                }));
                            } }),
                        react_1.default.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onChanged(listVal.filter((it, index) => index !== fieldIndex)) },
                            react_1.default.createElement(icons_1.Close, null)),
                        fieldIndex !== listVal.length - 1 && (react_1.default.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                react_1.default.createElement(core_1.Button, { onClick: () => {
                        onChanged([...listVal, '']);
                    }, variant: 'contained' },
                    react_1.default.createElement(icons_1.Add, null)),
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "]")));
        }
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_REAL: {
            const listVal = ((_q = part.value) !== null && _q !== void 0 ? _q : []);
            return (react_1.default.createElement(react_1.default.Fragment, null,
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "["),
                listVal.map((value, fieldIndex) => {
                    var _a;
                    return (react_1.default.createElement("div", { className: 'flex flex-row gap-1', key: fieldIndex },
                        react_1.default.createElement(core_1.TextField, { variant: 'outlined', key: fieldIndex, inputProps: {
                                className: classes.selectInput,
                            }, value: (_a = listVal[fieldIndex]) !== null && _a !== void 0 ? _a : '', onChange: (event) => {
                                const matches = event.target.value.match(/^-?([0-9]*|[0-9]+\.[0-9]*)$/);
                                if (!matches) {
                                    return;
                                }
                                onChanged(listVal.map((it, index) => {
                                    if (index === fieldIndex) {
                                        return event.target.value;
                                    }
                                    return it;
                                }));
                            } }),
                        react_1.default.createElement("span", { style: { paddingTop: 5 }, className: 'cursor-pointer', onClick: () => onChanged(listVal.filter((it, index) => index !== fieldIndex)) },
                            react_1.default.createElement(icons_1.Close, null)),
                        fieldIndex !== listVal.length - 1 && (react_1.default.createElement("span", { style: { paddingTop: 16 } }, ","))));
                }),
                react_1.default.createElement(core_1.Button, { onClick: () => {
                        onChanged([...listVal, '']);
                    }, variant: 'contained' },
                    react_1.default.createElement(icons_1.Add, null)),
                react_1.default.createElement("span", { style: { fontSize: '1.6rem' } }, "]")));
        }
    }
    return react_1.default.createElement("div", null, JSON.stringify(part));
};
//# sourceMappingURL=LiteralBuilder.js.map