"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OperatorBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const core_1 = require("@material-ui/core");
const styles_1 = require("@material-ui/core/styles");
const OperatorConfigMap_1 = require("../utils/OperatorConfigMap");
const useClasses = styles_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
exports.OperatorBuilder = (props) => {
    var _a;
    const classes = useClasses();
    const { rule, onChange, partIndex } = props;
    const part = rule.parts[partIndex];
    function onOperatorChange(event) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value: event.target.value }));
    }
    return (react_1.default.createElement(core_1.Select, { variant: 'outlined', value: (_a = part.value) !== null && _a !== void 0 ? _a : null, onChange: onOperatorChange, inputProps: { className: classes.selectInput } }, part.allowedOperators.map((item) => {
        const config = OperatorConfigMap_1.OperatorConfigMap[item];
        return (react_1.default.createElement(core_1.MenuItem, { key: item, value: item }, config.label));
    })));
};
//# sourceMappingURL=OperatorBuilder.js.map