"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariableBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const styles_1 = require("@material-ui/core/styles");
const core_1 = require("@material-ui/core");
function findUnique(value, index, self) {
    return self.findIndex((it) => value.value === it.value) === index;
}
const useClasses = styles_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
exports.VariableBuilder = (props) => {
    const classes = useClasses();
    const { rule, onChange, partIndex, variables } = props;
    const part = rule.parts[partIndex];
    const [choices, setChoices] = react_1.useState(() => {
        var _a, _b;
        let variable;
        if (part.value) {
            variable = variables.find((it) => it.variableName === part.value);
        }
        return (_b = (_a = variable === null || variable === void 0 ? void 0 : variable.variablePickerValues) === null || _a === void 0 ? void 0 : _a.map((it) => it.value)) !== null && _b !== void 0 ? _b : [];
    });
    const dropdownConfigs = react_1.useMemo(() => {
        var _a, _b, _c;
        let actualChoices = [...choices, undefined];
        if (part.value) {
            const variable = variables.find((it) => it.variableName === part.value);
            if (variable) {
                actualChoices = (_b = (_a = variable.variablePickerValues) === null || _a === void 0 ? void 0 : _a.map((it) => it.value)) !== null && _b !== void 0 ? _b : [variable.variableName];
            }
        }
        const returnVal = [];
        for (let outerIndex = 0; outerIndex < actualChoices.length; outerIndex++) {
            const filteredVariables = variables.filter((it) => {
                var _a;
                const variablePickerValues = (_a = it.variablePickerValues) !== null && _a !== void 0 ? _a : [
                    { label: it.displayVariableName, value: it.variableName },
                ];
                return (variablePickerValues.length >= outerIndex + 1 &&
                    actualChoices
                        .slice(0, outerIndex)
                        .reduce((acc, choice, index) => {
                        return acc && choice === variablePickerValues[index].value;
                    }, true));
            });
            returnVal.push({
                selected: (_c = actualChoices[outerIndex]) !== null && _c !== void 0 ? _c : null,
                options: filteredVariables
                    .map((variable) => {
                    var _a;
                    const pickerValues = (_a = variable.variablePickerValues) !== null && _a !== void 0 ? _a : [
                        {
                            label: variable.displayVariableName,
                            value: variable.variableName,
                        },
                    ];
                    return pickerValues[outerIndex];
                })
                    .filter(findUnique),
            });
        }
        return returnVal;
    }, [choices, part.value, variables]);
    function onVariableChange(index, event) {
        setChoices((choices) => {
            const newChoices = [
                ...choices.slice(0, index),
                event.target.value,
            ];
            const selectedVariable = variables.find((variable) => {
                var _a;
                const variablePickerValues = (_a = variable.variablePickerValues) !== null && _a !== void 0 ? _a : [
                    { label: variable.displayVariableName, value: variable.variableName },
                ];
                return (variablePickerValues.length === index + 1 &&
                    newChoices.reduce((acc, choice, index) => {
                        return acc && choice === variablePickerValues[index].value;
                    }, true));
            });
            if (selectedVariable && part.value !== selectedVariable.variableName) {
                onChange(partIndex, Object.assign(Object.assign({}, part), { value: selectedVariable.variableName }));
            }
            if (!selectedVariable && part.value) {
                onChange(partIndex, Object.assign(Object.assign({}, part), { value: undefined }));
            }
            return newChoices;
        });
    }
    return (react_1.default.createElement(react_1.default.Fragment, null, dropdownConfigs.map((dropdownConfig, index) => (react_1.default.createElement(core_1.Select, { key: index, variant: 'outlined', value: dropdownConfig.selected, onChange: onVariableChange.bind(null, index), inputProps: { className: classes.selectInput } }, dropdownConfig.options.map((option) => {
        return (react_1.default.createElement(core_1.MenuItem, { key: option.value, value: option.value }, option.label));
    }))))));
};
//# sourceMappingURL=VariableBuilder.js.map