"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DateRangeBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const styles_1 = require("@material-ui/core/styles");
const pickers_1 = require("@material-ui/pickers");
const ConditionBuilderVariable_1 = require("../../ConditionBuilderVariable");
const useClasses = styles_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
exports.DateRangeBuilder = (props) => {
    const classes = useClasses();
    const { rule, partIndex, onChange } = props;
    const part = rule.parts[partIndex];
    function onChanged(value) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value }));
    }
    const value = part.value || undefined;
    const dateValue = react_1.useMemo(() => {
        return {
            type: 'range',
            min: (value === null || value === void 0 ? void 0 : value.min) ? new Date(parseInt(value.min)) : null,
            max: (value === null || value === void 0 ? void 0 : value.max) ? new Date(parseInt(value.max)) : null,
        };
    }, [value]);
    switch (part.variableType) {
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE:
            return (react_1.default.createElement(react_1.default.Fragment, null,
                ' ',
                react_1.default.createElement(pickers_1.DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy', value: dateValue.min, onChange: (date) => onChanged({
                        type: 'range',
                        min: date ? date.getTime().toString() : '',
                        max: dateValue.max ? dateValue.max.getTime().toString() : '',
                    }) }),
                react_1.default.createElement("span", { className: 'flex items-center' }, "-"),
                react_1.default.createElement(pickers_1.DatePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy', value: dateValue.max, onChange: (date) => onChanged({
                        type: 'range',
                        min: dateValue.min ? dateValue.min.getTime().toString() : '',
                        max: date ? date.getTime().toString() : '',
                    }) })));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.TIME:
            return (react_1.default.createElement(react_1.default.Fragment, null,
                ' ',
                react_1.default.createElement(pickers_1.TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'HH:mm', value: dateValue.min, onChange: (date) => onChanged({
                        type: 'range',
                        min: date ? date.getTime().toString() : '',
                        max: dateValue.max ? dateValue.max.getTime().toString() : '',
                    }) }),
                react_1.default.createElement("span", { className: 'flex items-center' }, "-"),
                react_1.default.createElement(pickers_1.TimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'HH:mm', value: dateValue.max, onChange: (date) => onChanged({
                        type: 'range',
                        min: dateValue.min ? dateValue.min.getTime().toString() : '',
                        max: date ? date.getTime().toString() : '',
                    }) })));
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE_TIME:
            return (react_1.default.createElement(react_1.default.Fragment, null,
                ' ',
                react_1.default.createElement(pickers_1.DateTimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy HH:mm', value: dateValue.min, onChange: (date) => onChanged({
                        type: 'range',
                        min: date ? date.getTime().toString() : '',
                        max: dateValue.max ? dateValue.max.getTime().toString() : '',
                    }) }),
                react_1.default.createElement("span", { className: 'flex items-center' }, "-"),
                react_1.default.createElement(pickers_1.DateTimePicker, { autoOk: true, variant: 'inline', inputVariant: 'outlined', InputProps: {
                        classes: { input: classes.selectInput },
                    }, format: 'dd/MM/yyyy HH:mm', value: dateValue.max, onChange: (date) => onChanged({
                        type: 'range',
                        min: dateValue.min ? dateValue.min.getTime().toString() : '',
                        max: date ? date.getTime().toString() : '',
                    }) })));
    }
    return react_1.default.createElement("div", null, JSON.stringify(part));
};
//# sourceMappingURL=DateRangeBuilder.js.map