"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RankingBuilder = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const ConditionBuilderVariable_1 = require("../../ConditionBuilderVariable");
const RankingDraggableOption_1 = require("./RankingDraggableOption");
const react_dnd_1 = require("react-dnd");
const react_dnd_html5_backend_1 = tslib_1.__importDefault(require("react-dnd-html5-backend"));
const styles_1 = require("@material-ui/core/styles");
const core_1 = require("@material-ui/core");
function isStringArray(value) {
    return (Array.isArray(value) && (value.length === 0 || typeof value[0] === 'string'));
}
const useClasses = styles_1.makeStyles(() => {
    return {
        selectInput: {
            padding: '8px 16px',
        },
    };
});
exports.RankingBuilder = (props) => {
    const classes = useClasses();
    const { rule, partIndex, onChange } = props;
    const part = rule.parts[partIndex];
    function onChanged(value) {
        onChange(partIndex, Object.assign(Object.assign({}, part), { value }));
    }
    const { value, suggestions: actualSuggestions = [], literalType } = part;
    const suggestions = react_1.useMemo(() => {
        if (isStringArray(actualSuggestions))
            return actualSuggestions.map((it) => ({ value: it, label: it }));
        return actualSuggestions;
    }, [actualSuggestions]);
    const moveOptions = react_1.useCallback((from, to) => {
        if (!isStringArray(value)) {
            return;
        }
        const newValue = [...value];
        const item = value[from];
        newValue.splice(from, 1);
        newValue.splice(to, 0, item);
        onChanged(newValue);
    }, 
    // eslint-disable-next-line react-hooks/exhaustive-deps
    [value]);
    react_1.useEffect(() => {
        if (literalType === ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY_RANKING &&
            !value) {
            const newValue = suggestions.map((it) => it.value);
            onChanged(newValue);
        }
        if (literalType === 'RANKING_ORDER' && !value) {
            const newValue = {
                type: 'ranking_order',
                reverse: false,
                option1: '',
                option2: '',
            };
            onChanged(newValue);
        }
        if (literalType === 'RANKING_POSITION' && !value) {
            const newValue = {
                type: 'ranking_position',
                positions: [],
                option: '',
            };
            onChanged(newValue);
        }
        // eslint-disable-next-line
    }, [literalType, suggestions, value]);
    if (!value) {
        return null;
    }
    if (part.literalType === ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY_RANKING) {
        const convertedVal = value;
        return (react_1.default.createElement("div", null,
            react_1.default.createElement(react_dnd_1.DndProvider, { backend: react_dnd_html5_backend_1.default }, convertedVal.map((optionVal, index) => {
                var _a;
                const suggestion = suggestions.find((suggestion) => suggestion.value === optionVal);
                return (react_1.default.createElement(RankingDraggableOption_1.RankingDraggableOption, { key: optionVal, label: (_a = suggestion === null || suggestion === void 0 ? void 0 : suggestion.label) !== null && _a !== void 0 ? _a : optionVal, move: moveOptions, index: index }));
            }))));
    }
    if (part.literalType === 'RANKING_ORDER') {
        const { option1, option2, reverse } = value;
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(core_1.Select, { value: option1, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { option1: event.target.value })) }, suggestions.map((suggestion) => {
                return (react_1.default.createElement(core_1.MenuItem, { key: suggestion.value, value: suggestion.value }, suggestion.label));
            })),
            react_1.default.createElement(core_1.Select, { value: reverse.toString(), variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { reverse: event.target.value === 'true' })) },
                react_1.default.createElement(core_1.MenuItem, { value: 'false' }, "before"),
                react_1.default.createElement(core_1.MenuItem, { value: 'true' }, "after")),
            react_1.default.createElement(core_1.Select, { value: option2, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { option2: event.target.value })) }, suggestions.map((suggestion) => {
                return (react_1.default.createElement(core_1.MenuItem, { key: suggestion.value, value: suggestion.value }, suggestion.label));
            }))));
    }
    if (part.literalType === 'RANKING_POSITION') {
        const { option, positions } = value;
        return (react_1.default.createElement(react_1.default.Fragment, null,
            react_1.default.createElement(core_1.Select, { value: option, variant: 'outlined', inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { option: event.target.value })) }, suggestions.map((suggestion) => {
                return (react_1.default.createElement(core_1.MenuItem, { key: suggestion.value, value: suggestion.value }, suggestion.label));
            })),
            "at index",
            react_1.default.createElement(core_1.Select, { value: positions, variant: 'outlined', multiple: true, MenuProps: { getContentAnchorEl: null }, inputProps: { className: classes.selectInput }, onChange: (event) => onChanged(Object.assign(Object.assign({}, value), { positions: event.target.value })) }, suggestions.map((_, index) => {
                return (react_1.default.createElement(core_1.MenuItem, { key: index + 1, value: `${index + 1}` }, index + 1));
            }))));
    }
    return react_1.default.createElement("div", null, JSON.stringify(part));
};
//# sourceMappingURL=RankingBuilder.js.map