"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RankingDraggableOption = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const useDragSortableItem_1 = require("../../../drag-n-drop/useDragSortableItem");
const icons_1 = require("@material-ui/icons");
exports.RankingDraggableOption = (props) => {
    const { label, move, index } = props;
    const itemRef = react_1.useRef(null);
    const handleRef = react_1.useRef(null);
    const isDragging = useDragSortableItem_1.useDragSortableItem(index, move, itemRef, handleRef, 'RankingDraggableOption');
    return (react_1.default.createElement("div", { ref: itemRef, style: { opacity: isDragging ? 0 : 1 } },
        react_1.default.createElement("span", { ref: handleRef },
            react_1.default.createElement(icons_1.DragIndicator, null)),
        label));
};
//# sourceMappingURL=RankingDraggableOption.js.map