"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VariableType = exports.SpecialCharacters = exports.operators = exports.Operator = exports.ConjunctionConfigMap = exports.BLANK_CONDITONAL = exports.BLANK_MARKER = exports.Conjunction = void 0;
var Conjunction;
(function (Conjunction) {
    Conjunction["AND"] = "AND";
    Conjunction["OR"] = "OR";
    // NOT = 'NOT',
})(Conjunction = exports.Conjunction || (exports.Conjunction = {}));
exports.BLANK_MARKER = '$#blank#$';
exports.BLANK_CONDITONAL = `( ${exports.BLANK_MARKER} )`;
exports.ConjunctionConfigMap = {
    OR: {
        minExpressions: 1,
        maxExpressions: Infinity,
        getCombinedCondition: (conditions) => {
            if (conditions.length === 0) {
                return exports.BLANK_MARKER;
            }
            return `( ${conditions.join(' || ')} )`;
        },
        label: 'or',
    },
    AND: {
        minExpressions: 1,
        maxExpressions: Infinity,
        getCombinedCondition: (conditions) => {
            if (conditions.length === 0) {
                return exports.BLANK_MARKER;
            }
            return `( ${conditions.join(' & ')} )`;
        },
        label: 'and',
    },
};
var Operator;
(function (Operator) {
    Operator["LESSTHAN"] = "LESSTHAN";
    Operator["GREATERTHAN_EQUALS"] = "GREATERTHAN_EQUALS";
    Operator["GREATERTHAN"] = "GREATERTHAN";
    Operator["LESSTHAN_EQUALS"] = "LESSTHAN_EQUALS";
    Operator["EQUALS"] = "EQUALS";
    Operator["NOT_EQUALS"] = "NOT_EQUALS";
    Operator["BELONGS"] = "BELONGS";
    Operator["NOT_BELONGS"] = "NOT_BELONGS";
    Operator["BELONGS_RANGE"] = "BELONGS_RANGE";
    Operator["NOT_BELONGS_RANGE"] = "NOT_BELONGS_RANGE";
    Operator["STARTSWITH"] = "STARTSWITH";
    Operator["NOT_STARTSWITH"] = "NOT_STARTSWITH";
    Operator["ENDSWITH"] = "ENDSWITH";
    Operator["NOT_ENDSWITH"] = "NOT_ENDSWITH";
    Operator["EXACTMATCH"] = "EXACTMATCH";
    Operator["NOT_EXACTMATCH"] = "NOT_EXACTMATCH";
    Operator["ALLMATCH"] = "ALLMATCH";
    Operator["ANYMATCH"] = "ANYMATCH";
    Operator["CONTAINS_STRING"] = "CONTAINS_STRING";
    Operator["NOT_CONTAINS_STRING"] = "NOT_CONTAINS_STRING";
    Operator["CONTAINS_ANY_OF"] = "CONTAINS_ANY_OF";
    Operator["NOT_CONTAINS_ANY_OF"] = "NOT_CONTAINS_ANY_OF";
    Operator["CONTAINS_ALL_OF"] = "CONTAINS_ALL_OF";
    Operator["NOT_CONTAINS_ALL_OF"] = "NOT_CONTAINS_ALL_OF";
    Operator["EXACTEQUAL"] = "EXACTEQUAL";
    Operator["NOT_EXACTEQUAL"] = "NOT_EXACTEQUAL";
    Operator["RANKING_ORDER"] = "RANKING_ORDER";
    Operator["NOT_RANKING_ORDER"] = "NOT_RANKING_ORDER";
    Operator["RANKING_POSITION"] = "RANKING_POSITION";
    Operator["NOT_RANKING_POSITION"] = "NOT_RANKING_POSITION";
})(Operator = exports.Operator || (exports.Operator = {}));
exports.operators = Object.keys(Operator);
exports.SpecialCharacters = {
    COMMA: ',',
    TO: '-',
    WILDCARD: '*',
    DOLLAR: '$',
    HASH: '#',
};
var VariableType;
(function (VariableType) {
    VariableType["DOUBLE"] = "DOUBLE";
    VariableType["STRING"] = "STRING";
    VariableType["LIST_DOUBLE"] = "LIST_DOUBLE";
    VariableType["LIST_STRING"] = "LIST_STRING";
})(VariableType = exports.VariableType || (exports.VariableType = {}));
//# sourceMappingURL=Config.js.map