import { RulePart } from './RulePart';
import { Rule } from './Expression';
import { Operator } from './Config';
import { ConditionBuilderVariable, ConditionBuilderVariableType, LiteralType } from '../ConditionBuilderVariable';
export interface OperatorConfig {
    label: string;
    getCondition: (variableName: string, otherParts: RulePart[]) => string | undefined;
    supportedTypes: ConditionBuilderVariableType[];
    getLiteralType: (variableType: ConditionBuilderVariableType) => LiteralType;
    getRule: (condition: string, variables: ConditionBuilderVariable[]) => Rule | null;
}
export declare const OperatorConfigMap: Record<Operator, OperatorConfig>;
