import { Operator } from './Config';
import { ValueWithLabel } from '../ConditionBuilder';
import { ConditionBuilderVariable, ConditionBuilderVariableType, LiteralType } from '../ConditionBuilderVariable';
export declare enum RulePartType {
    VARIABLE = "VARIABLE",
    OPERATOR = "OPERATOR",
    LITERAL = "LITERAL"
}
interface RulePartBase {
    type: RulePartType;
    value: unknown;
}
export interface VariableRulePartBase extends RulePartBase {
    type: RulePartType.VARIABLE;
    isAnswerBased: boolean;
    value: string | undefined;
}
export interface NormalVariableRulePart extends VariableRulePartBase {
    type: RulePartType.VARIABLE;
    isAnswerBased: false;
}
export declare type VariableRulePart = NormalVariableRulePart;
export interface RangeLiteral {
    type: 'range';
    min: string;
    max: string;
}
export interface RankingPositionLiteral {
    type: 'ranking_position';
    option: string;
    positions: string[];
}
export interface RankingOrderLiteral {
    type: 'ranking_order';
    option1: string;
    option2: string;
    reverse: boolean;
}
export declare type LiteralValueType = Date | string | string[] | RangeLiteral | RankingPositionLiteral | RankingOrderLiteral | undefined;
export interface LiteralRulePart extends RulePartBase {
    type: RulePartType.LITERAL;
    variableType: ConditionBuilderVariableType;
    literalType: LiteralType;
    suggestions: string[] | undefined | ValueWithLabel[];
    conversion: 'number' | 'boolean' | 'string' | 'date' | undefined;
    multiSelect: boolean;
    value: LiteralValueType;
}
export interface OperatorRulePart extends RulePartBase {
    type: RulePartType.OPERATOR;
    allowedOperators: Operator[];
    value: Operator | undefined;
    variable?: ConditionBuilderVariable;
}
export declare type RulePart = VariableRulePart | OperatorRulePart | LiteralRulePart;
export {};
