"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVariableConversion = void 0;
const ConditionBuilderVariable_1 = require("../ConditionBuilderVariable");
function getVariableConversion(variableType) {
    switch (variableType) {
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.STRING:
            return 'string';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.INTEGER:
            return 'number';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.REAL:
            return 'number';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.BOOLEAN:
            return 'boolean';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE:
            return 'date';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.TIME:
            return 'date';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE_TIME:
            return 'date';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.IMAGE:
            return 'string';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.VIDEO:
            return 'string';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY:
            return 'string';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY_MULTIPLE:
            return 'string';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY_RANKING:
            return 'string';
        case 'RANGE':
            return undefined;
        case 'DATE_RANGE':
            return undefined;
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_STRING:
            return 'string';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_INTEGER:
            return 'number';
        case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_REAL:
            return 'number';
        case 'RANKING_ORDER':
            return undefined; // doesn't matter
        case 'RANKING_POSITION':
            return undefined; // doesn't matter
    }
}
exports.getVariableConversion = getVariableConversion;
//# sourceMappingURL=getVariableConversion.js.map