"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLiteralRulePart = exports.getOperatorRulePart = exports.getVariableRulePart = void 0;
const RulePart_1 = require("./RulePart");
const getVariableConversion_1 = require("./getVariableConversion");
const Config_1 = require("./Config");
const OperatorConfigMap_1 = require("./OperatorConfigMap");
const utils_1 = require("../../../utils");
const ConditionBuilderVariable_1 = require("../ConditionBuilderVariable");
function getVariableRulePart(variable) {
    return {
        type: RulePart_1.RulePartType.VARIABLE,
        isAnswerBased: false,
        value: variable,
    };
}
exports.getVariableRulePart = getVariableRulePart;
function getOperatorRulePart(operator, variableObj) {
    const allowedOperators = variableObj
        ? Config_1.operators.filter((operator) => {
            const supportedTypes = OperatorConfigMap_1.OperatorConfigMap[operator].supportedTypes;
            return supportedTypes.includes(variableObj.variableType);
        })
        : [operator];
    return {
        type: RulePart_1.RulePartType.OPERATOR,
        value: operator,
        allowedOperators,
        variable: variableObj,
    };
}
exports.getOperatorRulePart = getOperatorRulePart;
// TODO: handle negative numbers
function getLiteralValue(multiSelect, literalType, strRep) {
    var _a, _b;
    if (!strRep) {
        return undefined;
    }
    if (literalType === 'DATE_RANGE' || literalType === 'RANGE') {
        const matchIter = strRep.matchAll(/\d+(\.\d+)?/g);
        const min = (_a = matchIter.next().value) === null || _a === void 0 ? void 0 : _a[0];
        const max = (_b = matchIter.next().value) === null || _b === void 0 ? void 0 : _b[0];
        if (min && max) {
            return { min, max, type: 'range' };
        }
    }
    if (literalType === 'RANKING_ORDER') {
        const split = strRep.split(':');
        return {
            type: 'ranking_order',
            option1: split[0].slice(1, split[0].length - 1),
            option2: split[1].slice(1, split[1].length - 1),
            reverse: false,
        };
    }
    if (literalType === 'RANKING_POSITION') {
        const split = strRep.split(' ');
        const indexStrList = [];
        const matchIter = strRep.matchAll(/[^#]\d+[^#]/g);
        for (const match of matchIter) {
            indexStrList.push(match[0].slice(1, match[0].length - 1));
        }
        return {
            type: 'ranking_position',
            option: split[0].replace(/#/g, ''),
            positions: indexStrList,
        };
    }
    if (multiSelect) {
        let matchIter;
        const stringList = [];
        switch (literalType) {
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_STRING:
                matchIter = strRep.matchAll(/#.+?#/g);
                for (const match of matchIter) {
                    stringList.push(match[0].slice(1, match[0].length - 1));
                }
                return stringList;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_INTEGER:
                matchIter = strRep.matchAll(/\d+/g);
                for (const match of matchIter) {
                    stringList.push(match[0]);
                }
                return stringList;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.LIST_REAL:
                matchIter = strRep.matchAll(/\d+(\.\d+)?/g);
                for (const match of matchIter) {
                    stringList.push(match[0]);
                }
                return stringList;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY_RANKING:
                matchIter = strRep.matchAll(/\d+(\.\d+)?/g);
                for (const match of matchIter) {
                    stringList.push(match[0]);
                }
                return stringList;
        }
    }
    else {
        let match;
        switch (literalType) {
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.STRING:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.VIDEO:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.IMAGE:
                match = strRep.match(/#.+?#/);
                return match ? match[0].slice(1, match[0].length - 1) : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.INTEGER:
                match = strRep.match(/\d+/);
                return match ? match[0] : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.REAL:
                match = strRep.match(/\d+(\.\d+)?/);
                return match ? match[0] : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.BOOLEAN:
                return strRep.includes('true') ? 'true' : 'false';
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE:
                match = strRep.match(/\d+/);
                return (match === null || match === void 0 ? void 0 : match[0]) ? new Date(parseInt(match === null || match === void 0 ? void 0 : match[0])) : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.TIME:
                match = strRep.match(/\d+/);
                return (match === null || match === void 0 ? void 0 : match[0]) ? new Date(parseInt(match === null || match === void 0 ? void 0 : match[0])) : undefined;
            case ConditionBuilderVariable_1.ConditionBuilderVariableType.DATE_TIME:
                match = strRep.match(/\d+/);
                return (match === null || match === void 0 ? void 0 : match[0]) ? new Date(parseInt(match === null || match === void 0 ? void 0 : match[0])) : undefined;
        }
    }
    return undefined;
}
function getLiteralRulePart(operatorConfig, variable, strRep) {
    const literalType = operatorConfig.getLiteralType(variable.variableType);
    const multiSelect = literalType.startsWith('LIST') ||
        literalType === ConditionBuilderVariable_1.ConditionBuilderVariableType.CATEGORY_RANKING;
    const conversion = getVariableConversion_1.getVariableConversion(variable.variableType);
    let categoryValues = [];
    if (variable.categoryValues && variable.categoryValues.length > 0) {
        if (utils_1.isStringArray(variable.categoryValues)) {
            categoryValues = variable.categoryValues.filter((it) => it);
        }
        else {
            categoryValues = variable.categoryValues.filter((it) => it.value);
        }
    }
    return {
        type: RulePart_1.RulePartType.LITERAL,
        multiSelect,
        variableType: variable.variableType,
        suggestions: categoryValues.length > 0 ? categoryValues : undefined,
        value: getLiteralValue(multiSelect, literalType, strRep),
        literalType,
        conversion,
    };
}
exports.getLiteralRulePart = getLiteralRulePart;
//# sourceMappingURL=rulePartUtils.js.map