"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateItemForm = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const react_md_1 = require("react-md");
exports.CreateItemForm = (props) => {
    var _a, _b;
    const { cancel, createItem, saveDisabled, label, placeholder } = props;
    const cardTitle = (_a = props.cardTitle) !== null && _a !== void 0 ? _a : `Create new ${label}`;
    const id = (_b = props.id) !== null && _b !== void 0 ? _b : `create-new-${label}`;
    const [itemName, setItemName] = react_1.useState('');
    const tags = [];
    const addTag = react_1.useCallback((tag) => {
        tags.push(tag);
    }, [tags]);
    const onCardSubmit = react_1.useCallback((event) => {
        event.preventDefault();
        const name = itemName;
        if (!name) {
            return;
        }
        createItem(name);
    }, [createItem, itemName]);
    const onItemNameChange = react_1.useCallback((title) => {
        setItemName(title.toString());
    }, []);
    return (react_1.default.createElement("form", { onSubmit: onCardSubmit, style: { width: '100%', padding: 24 } },
        react_1.default.createElement("h1", { style: {
                fontSize: 18,
                fontFamily: 'serif',
                fontWeight: 700,
                color: 'black',
            } }, cardTitle),
        react_1.default.createElement("div", { style: {
                fontSize: 14,
                fontWeight: 400,
                color: 'rgba(37,41,45,0.5)',
                marginBottom: 4,
            } }, "Questionnaire Name"),
        react_1.default.createElement("input", { value: itemName, onChange: (event) => {
                onItemNameChange(event.target.value);
            }, style: {
                width: '100%',
                height: 40,
                color: '#000',
                borderRadius: 4,
                fontWeight: 400,
                border: 'thin solid #ededed',
                overflow: 'hidden',
                padding: '0 0.5em',
                marginBottom: 16,
            }, id: id, name: id, disabled: saveDisabled }),
        react_1.default.createElement("div", { style: { padding: 8, float: 'right' }, className: "md-grid" },
            react_1.default.createElement(react_md_1.Button, { primary: true, raised: true, disabled: saveDisabled || !itemName || itemName.trim().length == 0, type: 'submit', className: "md-cell" }, "Create"),
            react_1.default.createElement(react_md_1.Button, { raised: true, onClick: cancel, className: "md-cell" }, "Cancel"))));
};
//# sourceMappingURL=CreateItemForm.js.map