"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DrawingBoard = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
// eslint-disable-next-line
// @ts-ignore
const react_sketch_1 = require("@mayrestinpeace/react-sketch");
const react_1 = tslib_1.__importStar(require("react"));
const SettingsPopOver_1 = require("./SettingsPopOver");
exports.DrawingBoard = (props) => {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    let sketchRef = null;
    const { backgroundImage, onImageRecordingChanged } = props;
    const [anchorEl, setAnchorEl] = react_1.default.useState(null);
    const handleClose = react_1.useCallback(() => {
        setAnchorEl(null);
    }, []);
    const [lineColor, setLineColor] = react_1.useState('#000000');
    const [lineWidth, setLineWidth] = react_1.useState(4);
    const [opacity, setOpacity] = react_1.useState(0.2);
    const [fontSize, setFontSize] = react_1.useState(16);
    const [stampType, setStampType] = react_1.useState(react_sketch_1.StampType.Heart);
    const [tool, setSelectedTool] = react_1.useState(react_sketch_1.Tools.Pencil);
    return (react_1.default.createElement("div", null,
        react_1.default.createElement("div", { style: { display: 'flex', gap: 8 } },
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    flexDirection: 'column',
                    gap: 4,
                    background: '#FFF',
                } },
                react_1.default.createElement(icons_1.SelectAll, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                        background: tool === react_sketch_1.Tools.Select ? '#0000FF' : 'inherit',
                    }, onClick: () => setSelectedTool(react_sketch_1.Tools.Select), htmlColor: tool === react_sketch_1.Tools.Select ? '#FFFFFF' : '#000000' }),
                react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                    react_1.default.createElement(icons_1.Gesture, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === react_sketch_1.Tools.Pencil ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === react_sketch_1.Tools.Pencil ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Pencil) }),
                    tool === react_sketch_1.Tools.Pencil && (react_1.default.createElement(icons_1.Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                react_1.default.createElement(icons_1.PanoramaVerticalOutlined, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                        background: tool === react_sketch_1.Tools.Rectangle || tool === react_sketch_1.Tools.Circle
                            ? '#0000FF'
                            : 'inherit',
                    }, htmlColor: tool === react_sketch_1.Tools.Rectangle || tool === react_sketch_1.Tools.Circle
                        ? '#FFFFFF'
                        : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Rectangle) }),
                (tool === react_sketch_1.Tools.Rectangle || tool === react_sketch_1.Tools.Circle) && (react_1.default.createElement(react_1.default.Fragment, null,
                    react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                        react_1.default.createElement(icons_1.CheckBoxOutlineBlankOutlined, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                                background: tool === react_sketch_1.Tools.Rectangle ? '#0000FF' : 'inherit',
                            }, htmlColor: tool === react_sketch_1.Tools.Rectangle ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Rectangle) }),
                        tool === react_sketch_1.Tools.Rectangle && (react_1.default.createElement(icons_1.Settings, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                            }, onClick: (event) => 
                            // eslint-disable-next-line
                            // @ts-ignore
                            setAnchorEl(event.currentTarget) }))),
                    react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                        react_1.default.createElement(icons_1.RadioButtonUnchecked, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                                background: tool === react_sketch_1.Tools.Circle ? '#0000FF' : 'inherit',
                            }, htmlColor: tool === react_sketch_1.Tools.Circle ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Circle) }),
                        tool === react_sketch_1.Tools.Circle && (react_1.default.createElement(icons_1.Settings, { style: {
                                border: '1px solid black',
                                borderRadius: 4,
                                padding: 4,
                            }, onClick: (event) => 
                            // eslint-disable-next-line
                            // @ts-ignore
                            setAnchorEl(event.currentTarget) }))),
                    react_1.default.createElement("div", { style: { height: 1, background: '#0000FF', width: '100%' } }))),
                react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                    react_1.default.createElement(icons_1.Remove, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === react_sketch_1.Tools.Line ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === react_sketch_1.Tools.Line ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Line) }),
                    tool === react_sketch_1.Tools.Line && (react_1.default.createElement(icons_1.Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                    react_1.default.createElement(icons_1.ArrowUpward, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === react_sketch_1.Tools.Arrow ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === react_sketch_1.Tools.Arrow ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Arrow) }),
                    tool === react_sketch_1.Tools.Arrow && (react_1.default.createElement(icons_1.Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                    react_1.default.createElement(icons_1.TextFields, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === react_sketch_1.Tools.Text ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === react_sketch_1.Tools.Text ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Text) }),
                    tool === react_sketch_1.Tools.Text && (react_1.default.createElement(icons_1.Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                    react_1.default.createElement(icons_1.LayersClear, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === react_sketch_1.Tools.Eraser ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === react_sketch_1.Tools.Eraser ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Eraser) }),
                    tool === react_sketch_1.Tools.Eraser && (react_1.default.createElement(icons_1.Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                    react_1.default.createElement(icons_1.Highlight, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === react_sketch_1.Tools.Highlighter ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === react_sketch_1.Tools.Highlighter ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Highlighter) }),
                    tool === react_sketch_1.Tools.Highlighter && (react_1.default.createElement(icons_1.Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                react_1.default.createElement(icons_1.AdjustOutlined, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                        background: tool === react_sketch_1.Tools.Select ? '#0000FF' : 'inherit',
                    }, htmlColor: tool === react_sketch_1.Tools.Select ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Select) }),
                react_1.default.createElement("div", { style: { gap: 4, display: 'flex' } },
                    react_1.default.createElement(icons_1.Label, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                            background: tool === react_sketch_1.Tools.Stamp ? '#0000FF' : 'inherit',
                        }, htmlColor: tool === react_sketch_1.Tools.Stamp ? '#FFFFFF' : '#000000', onClick: () => setSelectedTool(react_sketch_1.Tools.Stamp) }),
                    tool === react_sketch_1.Tools.Stamp && (react_1.default.createElement(icons_1.Settings, { style: {
                            border: '1px solid black',
                            borderRadius: 4,
                            padding: 4,
                        }, onClick: (event) => 
                        // eslint-disable-next-line
                        // @ts-ignore
                        setAnchorEl(event.currentTarget) }))),
                react_1.default.createElement(icons_1.Undo, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                    }, onClick: () => {
                        if (sketchRef.canUndo()) {
                            sketchRef.undo();
                        }
                    } }),
                react_1.default.createElement(icons_1.Redo, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                    }, onClick: () => {
                        if (sketchRef.canRedo()) {
                            sketchRef.redo();
                        }
                    } }),
                react_1.default.createElement(icons_1.Delete, { style: {
                        border: '1px solid black',
                        borderRadius: 4,
                        padding: 4,
                    }, onClick: () => {
                        sketchRef.clear();
                        sketchRef.setBackgroundFromDataUrl('');
                    } })),
            react_1.default.createElement("div", { style: { position: 'relative', flexGrow: 1, display: 'flex' } },
                react_1.default.createElement("img", { src: backgroundImage, style: { position: 'absolute', width: '100%', height: '100%' } }),
                react_1.default.createElement(react_sketch_1.SketchField, { name: "sketch", className: "canvas-area", 
                    // eslint-disable-next-line @typescript-eslint/no-explicit-any
                    ref: (c) => (sketchRef = c), lineColor: lineColor, lineWidth: lineWidth, opacity: opacity, backgroundColor: 'transparent', width: backgroundImage ? '100%' : '100vw', height: backgroundImage ? '100%' : '100vh', 
                    // forceValue
                    tool: tool, setTool: setSelectedTool, fontSize: fontSize, stampType: stampType }))),
        react_1.default.createElement(core_1.Button, { variant: "contained", onClick: () => {
                onImageRecordingChanged === null || onImageRecordingChanged === void 0 ? void 0 : onImageRecordingChanged({ imageDataURL: sketchRef.toDataURL() });
            }, style: { marginTop: 8 } }, "Save"),
        react_1.default.createElement(core_1.Popover, { open: !!anchorEl, anchorEl: anchorEl, onClose: handleClose, anchorOrigin: {
                vertical: 'bottom',
                horizontal: 'center',
            }, transformOrigin: {
                vertical: 'top',
                horizontal: 'center',
            } },
            react_1.default.createElement(SettingsPopOver_1.SettingsPopOver, { lineColor: lineColor, setLineColor: setLineColor, lineWidth: lineWidth, setLineWidth: setLineWidth, opacity: opacity, setOpacity: setOpacity, fontSize: fontSize, setFontSize: setFontSize, stampType: stampType, setStampType: setStampType, tool: tool, close: () => setAnchorEl(null) }))));
};
//# sourceMappingURL=DrawingBoard.js.map