"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsPopOver = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const Icons_1 = require("./Icons");
// eslint-disable-next-line
// @ts-ignore
const react_sketch_1 = require("@mayrestinpeace/react-sketch");
exports.SettingsPopOver = (props) => {
    const { fontSize, lineColor, lineWidth, opacity, setFontSize, setLineColor, setLineWidth, setOpacity, setStampType, stampType, tool, close, } = props;
    return (react_1.default.createElement("div", { style: {
            display: 'flex',
            padding: 8,
            borderRadius: 4,
            minWidth: 240,
            flexDirection: 'column',
            gap: 12,
        } },
        (tool === react_sketch_1.Tools.Pencil ||
            tool === react_sketch_1.Tools.Rectangle ||
            tool === react_sketch_1.Tools.Circle ||
            tool === react_sketch_1.Tools.Line ||
            tool === react_sketch_1.Tools.Arrow ||
            tool === react_sketch_1.Tools.Eraser ||
            tool === react_sketch_1.Tools.Highlighter) && (react_1.default.createElement("div", { style: { width: '100%' } },
            react_1.default.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Line Width"),
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                react_1.default.createElement("div", { onClick: () => {
                        setLineWidth(4);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 4 ? '#AAA' : 'inherit',
                    } }, "4"),
                react_1.default.createElement("div", { onClick: () => {
                        setLineWidth(8);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 8 ? '#AAA' : 'inherit',
                    } }, "8"),
                react_1.default.createElement("div", { onClick: () => {
                        setLineWidth(12);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 12 ? '#AAA' : 'inherit',
                    } }, "12"),
                react_1.default.createElement("div", { onClick: () => {
                        setLineWidth(16);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: lineWidth === 16 ? '#AAA' : 'inherit',
                    } }, "16")),
            react_1.default.createElement("div", { style: { width: '100%', height: 1, background: '#AAA' } }))),
        tool === react_sketch_1.Tools.Highlighter && (react_1.default.createElement("div", { style: { width: '100%' } },
            react_1.default.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Opacity"),
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                react_1.default.createElement("div", { onClick: () => {
                        setOpacity(0.2);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.2 ? '#AAA' : 'inherit',
                    } }, "20%"),
                react_1.default.createElement("div", { onClick: () => {
                        setOpacity(0.4);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.4 ? '#AAA' : 'inherit',
                    } }, "40%"),
                react_1.default.createElement("div", { onClick: () => {
                        setOpacity(0.6);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.6 ? '#AAA' : 'inherit',
                    } }, "60%"),
                react_1.default.createElement("div", { onClick: () => {
                        setOpacity(0.8);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: opacity === 0.8 ? '#AAA' : 'inherit',
                    } }, "80%")),
            react_1.default.createElement("div", { style: { width: '100%', height: 1, background: '#AAA' } }))),
        tool === react_sketch_1.Tools.Text && (react_1.default.createElement("div", { style: { width: '100%' } },
            react_1.default.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Font Size"),
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                react_1.default.createElement("div", { onClick: () => {
                        setFontSize(12);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 12 ? '#AAA' : 'inherit',
                    } }, "12"),
                react_1.default.createElement("div", { onClick: () => {
                        setFontSize(16);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 16 ? '#AAA' : 'inherit',
                    } }, "16"),
                react_1.default.createElement("div", { onClick: () => {
                        setFontSize(20);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 20 ? '#AAA' : 'inherit',
                    } }, "20"),
                react_1.default.createElement("div", { onClick: () => {
                        setFontSize(24);
                        close();
                    }, style: {
                        cursor: 'pointer',
                        background: fontSize === 24 ? '#AAA' : 'inherit',
                    } }, "24")),
            react_1.default.createElement("div", { style: { width: '100%', height: 1, background: '#AAA' } }))),
        (tool === react_sketch_1.Tools.Pencil ||
            tool === react_sketch_1.Tools.Rectangle ||
            tool === react_sketch_1.Tools.Circle ||
            tool === react_sketch_1.Tools.Line ||
            tool === react_sketch_1.Tools.Arrow ||
            tool === react_sketch_1.Tools.Highlighter ||
            tool === react_sketch_1.Tools.Text) && (react_1.default.createElement("div", { style: { width: '100%' } },
            react_1.default.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Color"),
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                react_1.default.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#000000',
                        outlineWidth: lineColor === '#000000' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#000000');
                        close();
                    } }),
                react_1.default.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#FF1918',
                        outlineWidth: lineColor === '#FF1918' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#FF1918');
                        close();
                    } }),
                react_1.default.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#FEDE30',
                        outlineWidth: lineColor === '#FEDE30' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#FEDE30');
                        close();
                    } }),
                react_1.default.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#83C686',
                        outlineWidth: lineColor === '#83C686' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#83C686');
                        close();
                    } }),
                react_1.default.createElement("div", { style: {
                        width: 32,
                        height: 32,
                        borderRadius: 32,
                        background: '#2E8CFE',
                        outlineWidth: lineColor === '#2E8CFE' ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setLineColor('#2E8CFE');
                        close();
                    } })),
            react_1.default.createElement("div", { style: {
                    width: '100%',
                    height: 1,
                    background: '#AAA',
                    marginTop: 4,
                } }))),
        tool === react_sketch_1.Tools.Stamp && (react_1.default.createElement("div", { style: { width: '100%' } },
            react_1.default.createElement("div", { style: { fontWeight: 500, color: '#AAA' } }, "Icon"),
            react_1.default.createElement("div", { style: {
                    display: 'flex',
                    justifyContent: 'space-between',
                    fontSize: 24,
                    fontWeight: 500,
                    width: '100%',
                } },
                react_1.default.createElement("img", { src: `data:image/svg+xml;utf8,${Icons_1.heartSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === react_sketch_1.StampType.Heart ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(react_sketch_1.StampType.Heart);
                        close();
                    } }),
                react_1.default.createElement("img", { src: `data:image/svg+xml;utf8,${Icons_1.arrowSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === react_sketch_1.StampType.Arrow ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(react_sketch_1.StampType.Arrow);
                        close();
                    } }),
                react_1.default.createElement("img", { src: `data:image/svg+xml;utf8,${Icons_1.starSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === react_sketch_1.StampType.Star ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(react_sketch_1.StampType.Star);
                        close();
                    } }),
                react_1.default.createElement("img", { src: `data:image/svg+xml;utf8,${Icons_1.checkSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === react_sketch_1.StampType.Check ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(react_sketch_1.StampType.Check);
                        close();
                    } }),
                react_1.default.createElement("img", { src: `data:image/svg+xml;utf8,${Icons_1.crossSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === react_sketch_1.StampType.Cross ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(react_sketch_1.StampType.Cross);
                        close();
                    } }),
                react_1.default.createElement("img", { src: `data:image/svg+xml;utf8,${Icons_1.questionSVG}`, style: {
                        width: 32,
                        height: 32,
                        outlineWidth: stampType === react_sketch_1.StampType.Question ? 2 : 0,
                        outlineColor: '#000000',
                        outlineStyle: 'dashed',
                        outlineOffset: 2,
                    }, onClick: () => {
                        setStampType(react_sketch_1.StampType.Question);
                        close();
                    } })),
            react_1.default.createElement("div", { style: {
                    width: '100%',
                    height: 1,
                    background: '#AAA',
                    marginTop: 4,
                } })))));
};
//# sourceMappingURL=SettingsPopOver.js.map