"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HTMLEditor = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const tinymce_react_1 = require("@tinymce/tinymce-react");
const uuid_1 = tslib_1.__importDefault(require("uuid"));
const hooks_1 = require("../../hooks");
const plugins_1 = require("./plugins");
require("./HTMLEditor.scss");
exports.HTMLEditor = (props) => {
    const { value, onChange, style, variables, useVariablesPlugin = false, variablesPluginName = 'Variables', useQuestionnaireLinkPlugin = false, } = props;
    const editorRef = react_1.useRef(null);
    const editorId = react_1.useMemo(() => {
        return uuid_1.default.v4();
    }, []);
    const varRef = react_1.useRef([]);
    function setup() {
        plugins_1.createPlugins(varRef, useVariablesPlugin, variablesPluginName, useQuestionnaireLinkPlugin);
    }
    react_1.useEffect(() => {
        varRef.current = variables || [];
    }, [variables]);
    const [immediateCurrentValue, setCurrentValue] = react_1.useState(value);
    // sometimes tinymce creates multiple updates very fast.
    // call on change when it is stable
    const currentValue = hooks_1.useDebouncedValue(immediateCurrentValue, 1000);
    react_1.useEffect(() => {
        if (currentValue !== value) {
            onChange(currentValue);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [currentValue]);
    react_1.useLayoutEffect(() => {
        var _a, _b;
        const editorComponent = editorRef.current;
        if (currentValue !== value && editorComponent) {
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            (_b = (_a = editorComponent.editor) === null || _a === void 0 ? void 0 : _a.setContent) === null || _b === void 0 ? void 0 : _b.call(_a, plugins_1.addChips(value, varRef.current));
            setCurrentValue(value);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [value]);
    const editorInitialValue = react_1.useMemo(() => {
        return plugins_1.addChips(currentValue, variables !== null && variables !== void 0 ? variables : []);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    const onEditorChange = react_1.useCallback((value) => {
        setCurrentValue(plugins_1.removeChips(value));
    }, []);
    // have provided initial value because value doesn't work
    // the editor doesn't work as a controlled component
    const questionnaireToolbarItems = [];
    if (useQuestionnaireLinkPlugin) {
        questionnaireToolbarItems.push('questionnairelink');
    }
    if (useVariablesPlugin) {
        questionnaireToolbarItems.push('htmleditorvars');
    }
    const questionnaireToolbarItemsStr = questionnaireToolbarItems.join(' | ');
    const questionnairePluginItems = [];
    if (useQuestionnaireLinkPlugin) {
        questionnairePluginItems.push('questionnairelink');
    }
    if (useVariablesPlugin) {
        questionnairePluginItems.push('htmleditorvars');
    }
    const questionnairePluginItemsStr = questionnairePluginItems.join(' ');
    return (react_1.default.createElement("div", { style: style, className: 'flex flex-col items-stretch' },
        react_1.default.createElement(tinymce_react_1.Editor, { ref: editorRef, id: editorId, initialValue: editorInitialValue, init: {
                height: 200,
                menubar: false,
                setup,
                plugins: [
                    'advlist autolink lists link image charmap print preview anchor',
                    'searchreplace visualblocks fullscreen',
                    'insertdatetime media table paste code help wordcount ' +
                        questionnairePluginItemsStr,
                ],
                toolbar: 'undo redo | formatselect | fontsizeselect |bold italic backcolor | link |' +
                    'alignleft aligncenter alignright alignjustify | ' +
                    'bullist numlist outdent indent | removeformat | help | ' +
                    questionnaireToolbarItemsStr,
            }, tinymceScriptSrc: "https://cdnjs.cloudflare.com/ajax/libs/tinymce/5.6.1/tinymce.min.js", onEditorChange: onEditorChange })));
};
//# sourceMappingURL=HTMLEditor.js.map