"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImageRecorderComponent = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const image_1 = require("../../web-media-recorder/image");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const utils_1 = require("../../utils");
const NotificationStore_1 = require("../../stores/NotificationStore");
exports.ImageRecorderComponent = (props) => {
    var _a;
    const recorderRef = react_1.useRef();
    const [recorder, setRecorderState] = react_1.useState();
    const [isWaiting, setWaiting] = react_1.useState(false);
    const [error, setError] = react_1.useState();
    const [isRecording, setIsRecording] = react_1.useState(false);
    const imageElementRef = react_1.useRef(null);
    const previewRef = react_1.useRef(null);
    const [imageRecordingData, setImageRecordingData] = react_1.useState((_a = props.data) !== null && _a !== void 0 ? _a : undefined);
    function setRecorder(recorder) {
        setRecorderState(recorder);
        recorderRef.current = recorder;
    }
    react_1.useEffect(() => {
        return () => {
            if (recorderRef.current) {
                recorderRef.current.cancel();
            }
        };
    }, []);
    react_1.useEffect(() => {
        var _a;
        if (props.data !== (imageRecordingData !== null && imageRecordingData !== void 0 ? imageRecordingData : null)) {
            (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, imageRecordingData !== null && imageRecordingData !== void 0 ? imageRecordingData : null);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [imageRecordingData]);
    react_1.useEffect(() => {
        var _a, _b;
        if (props.data !== undefined &&
            imageRecordingData !== ((_a = props.data) !== null && _a !== void 0 ? _a : undefined)) {
            setImageRecordingData((_b = props.data) !== null && _b !== void 0 ? _b : undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.data]);
    // useImagePermissions(setError);
    react_1.useEffect(() => {
        if (error) {
            setRecorder(undefined);
            setIsRecording(false);
            setImageRecordingData(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    function onRetryClicked() {
        setError(undefined);
    }
    function onRecordClicked() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            try {
                if (!previewRef.current)
                    return;
                const recorder = yield image_1.getImageRecorder(previewRef.current);
                setRecorder(recorder);
                setIsRecording(true);
                setImageRecordingData(undefined);
            }
            catch (e) {
                if (e.message.toLowerCase().includes('permission')) {
                    setError(image_1.ImageRecorderError.PERMISSION_DENIED);
                }
                else if (e.message.toLowerCase().includes('device not found')) {
                    setError(image_1.ImageRecorderError.NOT_SUPPORTED);
                }
                else {
                    setError(image_1.ImageRecorderError.UNKNOWN);
                }
            }
            setWaiting(false);
        });
    }
    function onDeleteClicked() {
        setImageRecordingData(undefined);
    }
    function onCaptureClicked() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            if (!recorder) {
                return;
            }
            const recordingData = yield recorder.capture();
            setIsRecording(false);
            setRecorder(undefined);
            setImageRecordingData(recordingData);
            setWaiting(false);
        });
    }
    const pushNotification = utils_1.useSelector((store) => {
        return store.notificationStore.pushNotification;
    });
    react_1.useEffect(() => {
        if (error !== undefined) {
            let message;
            switch (error) {
                case image_1.ImageRecorderError.NOT_SECURE_CONTEXT:
                    message =
                        'There is no secure context. Need secure context for recording.';
                    break;
                case image_1.ImageRecorderError.NOT_SUPPORTED:
                    message =
                        'Video or audio recording is not supported in this system.' +
                            ' Make sure both camera and mic are attached and are enabled.';
                    break;
                case image_1.ImageRecorderError.PERMISSION_DENIED:
                    message = 'Please provide permission for audio and video recording.';
                    break;
                case image_1.ImageRecorderError.UNKNOWN:
                    message = 'Unexpected error has happened.';
                    break;
            }
            pushNotification({
                message,
                type: NotificationStore_1.NotificationType.ERROR,
            });
            setError(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    return (react_1.default.createElement("div", { className: "flex flex-col items-center justify-center w-full h-full" },
        react_1.default.createElement("span", { className: 'self-start' }, "Image"),
        react_1.default.createElement("div", { className: "flex flex-col gap-4 items-center justify-center" },
            react_1.default.createElement("div", { className: `flex items-stretch relative`, style: {
                    height: isRecording ? 220 : 0,
                    width: isRecording ? 'auto' : 0,
                } },
                react_1.default.createElement("video", { className: "flex-grow min-w-0 min-h-0", ref: previewRef, autoPlay: true, muted: true })),
            !imageRecordingData && (react_1.default.createElement(core_1.Button, { disabled: isWaiting, variant: 'contained', onClick: !isRecording ? onRecordClicked : onCaptureClicked }, !isRecording ? react_1.default.createElement(icons_1.FiberManualRecord, null) : react_1.default.createElement(icons_1.Camera, null))),
            imageRecordingData && (react_1.default.createElement("div", { className: "flex items-stretch relative", style: {
                    width: 400,
                    height: 220,
                } },
                react_1.default.createElement("img", { className: "flex-grow min-w-0 object-contain ", ref: imageElementRef, src: imageRecordingData.imageUrl }),
                react_1.default.createElement("span", { className: "top-0 right-0 absolute" },
                    react_1.default.createElement(core_1.Button, { variant: "contained", onClick: onDeleteClicked },
                        react_1.default.createElement(icons_1.Delete, null))))))));
};
//# sourceMappingURL=ImageRecorder.js.map