"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadingComponent = void 0;
const tslib_1 = require("tslib");
const mobx_react_1 = require("mobx-react");
const react_1 = tslib_1.__importStar(require("react"));
const Loader_1 = require("../loader/Loader");
function LoadingComponent(props) {
    const { response: networkResponse, render, component: Component, children, } = props;
    const { data, isLoading, error } = mobx_react_1.useObserver(() => {
        return {
            data: networkResponse.data,
            isLoading: networkResponse.isLoading,
            error: networkResponse.error,
        };
    });
    const renderFunction = react_1.useCallback(() => {
        if (isLoading)
            return react_1.default.createElement(Loader_1.Loader, null);
        if (error)
            return react_1.default.createElement(react_1.default.Fragment, null, "Oops, something went wrong!");
        if (!data)
            return react_1.default.createElement(react_1.default.Fragment, null);
        if (render)
            return render(data);
        if (children) {
            if (typeof children === 'function') {
                return children(data);
            }
            else {
                return children;
            }
        }
        if (Component)
            return react_1.default.createElement(Component, { response: data });
        return react_1.default.createElement(react_1.default.Fragment, null);
    }, [Component, children, data, error, isLoading, render]);
    return react_1.default.createElement(mobx_react_1.Observer, null, renderFunction);
}
exports.LoadingComponent = LoadingComponent;
//# sourceMappingURL=LoadingComponent.js.map