"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.replaceHtmlAtCaret = exports.getSuggestionText = exports.getTextAtCaret = exports.insertTextAtCaret = exports.setCaretPosition = exports.getCaretPosition = exports.transformInnerHTMLToValue = exports.transformValueToInnerHTMl = exports.spanClose = exports.spanOpen = void 0;
const utils_1 = require("../../utils");
exports.spanOpen = '<span class="questionnaire-suggestion-tag" contenteditable="false">';
exports.spanClose = '</span>';
function transformValueToInnerHTMl(value) {
    var _a;
    const html = (_a = value
        .replace(/<[^#]*>/g, (a) => {
        return `&lt;${a.substring(2, a.length - 1)}&rt;`;
    })
        .replace(/ /g, '&nbsp;')
        .replace(/<#[a-zA-Z][a-zA-Z0-9_]*?>/g, (a) => {
        return `${exports.spanOpen}#${a.substring(2, a.length - 1)}${exports.spanClose}`;
    })
        .replace(/[\r\n]+/g, '<br/>')) !== null && _a !== void 0 ? _a : '';
    return html + '<br/>';
}
exports.transformValueToInnerHTMl = transformValueToInnerHTMl;
function transformInnerHTMLToValue(childNodes) {
    let text = '';
    for (let i = 0; i < childNodes.length; i++) {
        const childNode = childNodes[i];
        if (childNode instanceof HTMLSpanElement) {
            text = text.concat(`<${childNode.innerText}>`);
        }
        else if (childNode instanceof HTMLBRElement &&
            i !== childNodes.length - 1) {
            text = text.concat('\n');
        }
        else if (childNode instanceof Text) {
            text = text.concat(utils_1.htmlUnescape(childNode.textContent));
        }
    }
    return text;
}
exports.transformInnerHTMLToValue = transformInnerHTMLToValue;
function getCaretPosition() {
    let caretPos = 0, sel, range;
    if (window.getSelection) {
        sel = window.getSelection();
        range = sel.getRangeAt(0);
        // if (range.commonAncestorContainer.parentNode === editableDiv) {
        caretPos = range.endOffset;
        // }
    }
    return caretPos;
}
exports.getCaretPosition = getCaretPosition;
// FIXME: doesn't work in some cases
function setCaretPosition(pos, element) {
    // for contentedit field
    if (element.isContentEditable) {
        element.focus();
        document.getSelection().collapse(element, pos);
        return;
    }
    element.setSelectionRange(pos, pos);
}
exports.setCaretPosition = setCaretPosition;
function insertTextAtCaret(text, editableDiv) {
    let sel, range;
    if (window.getSelection) {
        sel = window.getSelection();
        if (sel.getRangeAt && sel.rangeCount) {
            range = sel.getRangeAt(0);
            range.deleteContents();
            const nodes = text
                .split('\r\n')
                .flatMap((it) => it.split('\n'))
                .flatMap((it) => [
                document.createTextNode(it),
                document.createElement('br'),
            ])
                .reverse()
                .slice(1);
            nodes.forEach((node) => range.insertNode(node));
        }
    }
    else if (document.selection && document.selection.createRange) {
        document.selection.createRange().text = text;
    }
    setCaretPosition(getCaretPosition(), editableDiv);
}
exports.insertTextAtCaret = insertTextAtCaret;
function getTextAtCaret(editableDiv) {
    let text = '', sel, range;
    if (window.getSelection) {
        sel = window.getSelection();
        if (sel.rangeCount) {
            range = sel.getRangeAt(0);
            if (range.commonAncestorContainer.parentNode === editableDiv) {
                text = range.commonAncestorContainer.textContent;
            }
        }
    }
    return text;
}
exports.getTextAtCaret = getTextAtCaret;
function getSuggestionText(element) {
    const caretPosition = getCaretPosition();
    const inputText = getTextAtCaret(element);
    let suggestionText = '';
    for (let i = caretPosition - 1; i > 0 && inputText[i] !== '#'; i--) {
        suggestionText = inputText[i].concat(suggestionText);
    }
    return suggestionText;
}
exports.getSuggestionText = getSuggestionText;
function replaceHtmlAtCaret(html, numberOfCharactersToReplace) {
    let sel, range;
    if (window.getSelection) {
        let i;
        // IE9 and non-IE
        sel = window.getSelection();
        sel.collapseToStart();
        for (i = 0; i < numberOfCharactersToReplace; i++) {
            sel.modify('move', 'backward', 'character');
        }
        for (i = 0; i < numberOfCharactersToReplace; i++) {
            sel.modify('extend', 'forward', 'character');
        }
        if (sel.getRangeAt && sel.rangeCount) {
            range = sel.getRangeAt(0);
            range.deleteContents();
            // Range.createContextualFragment() would be useful here but is
            // non-standard and not supported in all browsers (IE9, for one)
            const el = document.createElement('div');
            el.innerHTML = html;
            const frag = document.createDocumentFragment();
            let node, lastNode;
            while ((node = el.firstChild)) {
                lastNode = frag.appendChild(node);
            }
            range.insertNode(frag);
            // Preserve the selection
            if (lastNode) {
                range = range.cloneRange();
                range.setStartAfter(lastNode);
                range.collapse(true);
                sel.removeAllRanges();
                sel.addRange(range);
            }
        }
    }
    // else if (document.selection && document.selection.type != 'Control') {
    //   // IE < 9
    //   document.selection.collapseToStart();
    //   for (var i = 0; i < numberOfCharactersToReplace; i++) {
    //     document.selection.modify('move', 'backward', 'character');
    //   }
    //   for (var i = 0; i < numberOfCharactersToReplace; i++) {
    //     document.selection.modify('extend', 'forward', 'character');
    //   }
    //   document.selection.createRange().pasteHTML(html);
    // }
}
exports.replaceHtmlAtCaret = replaceHtmlAtCaret;
//# sourceMappingURL=utilities.js.map