"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationProvider = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const utils_1 = require("../../utils");
const notistack_1 = require("notistack");
const NotificationStore_1 = require("../../stores/NotificationStore");
const mobx_react_1 = require("mobx-react");
const uuid_1 = tslib_1.__importDefault(require("uuid"));
const core_1 = require("@material-ui/core");
const NotificationTypeSnackbarVariantMapping = {
    [NotificationStore_1.NotificationType.WARNING]: 'warning',
    [NotificationStore_1.NotificationType.ERROR]: 'error',
    [NotificationStore_1.NotificationType.SUCCESS]: 'success',
    [NotificationStore_1.NotificationType.INFO]: 'info',
};
const NotificationProvider = (props) => {
    const { notifications, clear } = utils_1.useSelector((store) => {
        return {
            notifications: store.notificationStore.notifications,
            clear: store.notificationStore.clearQueue,
        };
    });
    const { enqueueSnackbar } = notistack_1.useSnackbar();
    mobx_react_1.useObserver(() => {
        notifications.forEach((notification) => {
            var _a;
            enqueueSnackbar(notification.message, {
                id: notification.id || uuid_1.default.v4(),
                persist: notification.persist,
                variant: notification.type &&
                    NotificationTypeSnackbarVariantMapping[notification.type],
                action: (_a = notification.actionButtons) === null || _a === void 0 ? void 0 : _a.map((actionButton) => {
                    return (react_1.default.createElement(core_1.Button, { onClick: actionButton.action }, actionButton.label));
                }),
            });
            if (notifications.length > 0) {
                clear();
            }
        });
    });
    return null;
};
const NotificationProviderWrapper = (props) => {
    return (react_1.default.createElement(notistack_1.SnackbarProvider, null,
        react_1.default.createElement(NotificationProvider, null),
        props.children));
};
exports.NotificationProvider = NotificationProviderWrapper;
//# sourceMappingURL=NotificationProvider.js.map