"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourceSelector = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const react_md_1 = require("react-md");
const services_1 = require("../../services");
const utilities_1 = require("./utilities");
const models_1 = require("../../models");
const core_1 = require("@material-ui/core");
const MIME_TYPES = {
    [models_1.ResourceType.VIDEO]: 'video/*',
    [models_1.ResourceType.AUDIO]: 'audio/*',
    [models_1.ResourceType.IMAGE]: 'image/*',
};
exports.ResourceSelector = (props) => {
    // const [uploading, toChangeToPropsUpload] = useState(false);
    const [urlText, setUrlText] = react_1.useState('');
    const fileInputRef = react_1.useRef(null);
    react_1.useEffect(() => {
        setUrlText('');
    }, [props.value.url]);
    function removeResource() {
        props.onChange({
            isUploading: false,
            url: '',
        });
    }
    function onUrlTextChange(event) {
        const target = event.target;
        setUrlText(target.value);
    }
    function selectUrl() {
        const url = urlText;
        setUrlText('');
        props.onChange({
            isUploading: false,
            url,
        });
    }
    function selectFile(event) {
        if (!props.bucketName) {
            throw new Error('Bucket name not provided');
        }
        const element = event.target;
        const files = element.files;
        if (!files || files.length === 0) {
            return;
        }
        const file = files[0];
        props.onChange({
            isUploading: true,
            url: '',
        });
        services_1.UtilityService.uploadFile(file, props.bucketName, props.uploadServiceType)
            .then((response) => {
            props.onChange({
                isUploading: false,
                url: response.url,
            });
        })
            .catch(() => {
            props.onChange({
                isUploading: false,
                url: '',
            });
            alert('error isUploading image');
        });
        element.value = '';
    }
    const type = props.type;
    const mimeType = MIME_TYPES[type];
    function displayResource() {
        switch (type) {
            case models_1.ResourceType.IMAGE:
                return utilities_1.getImage(props.value.url);
            case models_1.ResourceType.VIDEO:
                return utilities_1.getVideo(props.value.url);
            case models_1.ResourceType.AUDIO:
                return utilities_1.getAudio(props.value.url);
        }
    }
    function onTypeChange(event) {
        if (props.onTypeChange) {
            const target = event.target;
            const newType = target.value;
            props.onTypeChange(newType);
        }
    }
    const value = props.value;
    function onFileUploadClicked() {
        var _a;
        (_a = fileInputRef.current) === null || _a === void 0 ? void 0 : _a.click();
    }
    return (react_1.default.createElement("div", { className: 'relative h-full', style: { minHeight: 100 } },
        props.value.url && (react_1.default.createElement(react_1.default.Fragment, null,
            displayResource(),
            props.enableRemoveResource && !props.disabled && (react_1.default.createElement(react_md_1.Button, { icon: true, onClick: removeResource, style: {
                    color: 'red',
                    left: 0,
                    position: 'absolute',
                    top: 0,
                    transform: 'scale(0.75)',
                    transformOrigin: '0 0',
                } }, "cancel")))),
        !value.url && (react_1.default.createElement(react_1.default.Fragment, null,
            value.isUploading && 'loading',
            !value.isUploading && (react_1.default.createElement("div", { className: 'flex flex-col', style: props.isValid || props.isValid === undefined
                    ? {}
                    : { border: '2px solid red', borderRadius: '7px' } },
                props.types && props.types.length > 1 && (react_1.default.createElement("label", null,
                    "Select Type: \u00A0\u00A0",
                    react_1.default.createElement("select", { onChange: onTypeChange, value: type, disabled: props.disabled }, props.types.map((currentType) => (react_1.default.createElement("option", { value: currentType, key: currentType }, currentType)))))),
                (!props.types || props.types.length <= 1) && (react_1.default.createElement("div", { className: 'text-md p-5' },
                    "Select ",
                    props.type)),
                props.enableUrlInput && (react_1.default.createElement("div", { className: 'self-center flex justify-center items-center my-2' },
                    react_1.default.createElement("div", { className: 'mx-2' },
                        react_1.default.createElement(core_1.TextField, { label: 'URL', onChange: onUrlTextChange, disabled: props.disabled, value: urlText, variant: 'outlined' })),
                    react_1.default.createElement("div", { className: 'mx-2' },
                        react_1.default.createElement(core_1.Button, { onClick: selectUrl, variant: 'contained', disableElevation: true, disabled: props.disabled }, "insert")))),
                props.enableFileUpload && (react_1.default.createElement("div", { className: 'self-center my-2' },
                    react_1.default.createElement("input", { type: "file", accept: mimeType, disabled: props.disabled, onChange: selectFile, className: 'hidden', ref: fileInputRef }),
                    react_1.default.createElement(core_1.Button, { onClick: onFileUploadClicked, variant: 'contained', disabled: props.disabled, disableElevation: true }, "Upload File"))))))),
        props.delete && !props.value.isUploading && !props.disabled && (react_1.default.createElement(react_md_1.Button, { icon: true, onClick: props.delete, style: {
                color: 'red',
                position: 'absolute',
                right: 0,
                top: 0,
                transform: 'scale(0.75)',
                transformOrigin: '100% 0',
            } }, "delete"))));
};
exports.ResourceSelector.defaultProps = {
    enableFileUpload: true,
    enableRemoveResource: true,
    enableUrlInput: true,
};
//# sourceMappingURL=ResourceSelector.js.map