"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAudio = exports.getVideo = exports.getImage = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importDefault(require("react"));
const style = {
    maxHeight: '100%',
    objectFit: 'contain',
    position: 'absolute',
    top: '50%',
    transform: 'translateY(-50%)',
    width: '100%',
};
function getImage(url) {
    return react_1.default.createElement("img", { src: url, alt: 'lookBook', style: style });
}
exports.getImage = getImage;
function getVideo(url) {
    return react_1.default.createElement("video", { src: url, style: style, controls: true, preload: "metadata" });
}
exports.getVideo = getVideo;
function getAudio(url) {
    return react_1.default.createElement("audio", { src: url, style: style, controls: true, preload: "metadata" });
}
exports.getAudio = getAudio;
//# sourceMappingURL=utilities.js.map