"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RouteBasedSegmentedControl = exports.RouteBasedSegmentedControlComponent = void 0;
const tslib_1 = require("tslib");
/* eslint-disable react/prop-types */
const react_1 = tslib_1.__importDefault(require("react"));
const react_router_dom_1 = require("react-router-dom");
const SegmentedControl_1 = require("../segmented-control/SegmentedControl");
function RouteBasedSegmentedControlComponent(props) {
    const parentHistory = props.history;
    const parentMatch = props.match;
    function setSelectedTab(tab) {
        parentHistory.push(`${parentMatch.url}/${tab}`);
    }
    return (react_1.default.createElement(react_router_dom_1.Switch, null,
        react_1.default.createElement(react_router_dom_1.Route, { path: `${parentMatch.url}/:selectedTab?`, render: (renderProps) => {
                const selectedTab = renderProps.match.params.selectedTab;
                return (react_1.default.createElement(SegmentedControl_1.SegmentedControl, { tabsData: props.tabsData, selectedTab: selectedTab, setSelectedTab: setSelectedTab }));
            } })));
}
exports.RouteBasedSegmentedControlComponent = RouteBasedSegmentedControlComponent;
exports.RouteBasedSegmentedControl = react_router_dom_1.withRouter(RouteBasedSegmentedControlComponent);
//# sourceMappingURL=RouteBasedSegmentedControl.js.map