"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SegmentedControl = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const SegmentedControl_module_scss_1 = tslib_1.__importDefault(require("./SegmentedControl.module.scss"));
const utils_1 = require("../../utils");
const classNames = utils_1.classNamesWithModules(SegmentedControl_module_scss_1.default);
function SegmentedControl(props) {
    const tabsData = props.tabsData;
    const selectedTab = props.selectedTab;
    const selectedTabData = react_1.useMemo(() => tabsData.find((tabData) => tabData.key === selectedTab), [tabsData, selectedTab]);
    if (!selectedTabData && tabsData.length) {
        props.setSelectedTab(tabsData[0].key);
    }
    function changeTab(event) {
        const element = event.target;
        const tab = element.dataset.tab;
        if (!tab)
            return;
        props.setSelectedTab(tab);
    }
    return (react_1.default.createElement("div", { className: classNames('center-tabs') },
        react_1.default.createElement("div", { className: classNames('header') },
            react_1.default.createElement("div", { className: classNames('tabs-container') }, tabsData.map((tabData) => (react_1.default.createElement("div", { className: classNames('tab', {
                    'tab--active': tabData.key === selectedTab,
                }), onClick: changeTab, key: tabData.key, "data-tab": tabData.key }, tabData.name))))),
        selectedTabData && (react_1.default.createElement("div", { className: classNames('body') }, selectedTabData.body))));
}
exports.SegmentedControl = SegmentedControl;
//# sourceMappingURL=SegmentedControl.js.map