"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SentryWrapper = void 0;
const tslib_1 = require("tslib");
const Sentry = tslib_1.__importStar(require("@sentry/browser"));
const config_1 = require("../../config");
const react_1 = tslib_1.__importStar(require("react"));
class SentryWrapper extends react_1.Component {
    constructor(props) {
        super(props);
        this.state = { hasError: false };
        this.recreateTree = this.recreateTree.bind(this);
    }
    componentDidMount() {
        if (!config_1.config.isDevelopment) {
            Sentry.init({
                dsn: this.props.dsn,
            });
        }
    }
    componentDidCatch(error, errorInfo) {
        this.setState({ hasError: true });
        if (!config_1.config.isDevelopment) {
            Sentry.withScope((scope) => {
                Object.keys(errorInfo).forEach((key) => {
                    scope.setExtra(key, errorInfo[key]);
                });
                Sentry.captureException(error);
            });
        }
    }
    recreateTree() {
        this.setState({ hasError: false });
    }
    submitFeedback() {
        Sentry.showReportDialog();
    }
    render() {
        if (this.state.hasError) {
            return (react_1.default.createElement("div", { style: { padding: 10 } },
                config_1.config.isDevelopment && (react_1.default.createElement(react_1.default.Fragment, null,
                    "there is some dev error",
                    react_1.default.createElement("button", { onClick: this.recreateTree }, "Recreate Tree"))),
                !config_1.config.isDevelopment && (react_1.default.createElement(react_1.default.Fragment, null,
                    "There has been an error. It has been logged in sentry.",
                    react_1.default.createElement("br", null),
                    "Please reload the page. Contact admin in case error persists.",
                    react_1.default.createElement("br", null),
                    react_1.default.createElement("button", { onClick: this.submitFeedback }, "Report Feedback")))));
        }
        return this.props.children;
    }
}
exports.SentryWrapper = SentryWrapper;
//# sourceMappingURL=SentryWrapper.js.map