"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VideoRecorderComponent = void 0;
const tslib_1 = require("tslib");
const react_1 = tslib_1.__importStar(require("react"));
const video_1 = require("../../web-media-recorder/video");
const core_1 = require("@material-ui/core");
const icons_1 = require("@material-ui/icons");
const utils_1 = require("../../utils");
const NotificationStore_1 = require("../../stores/NotificationStore");
exports.VideoRecorderComponent = (props) => {
    var _a;
    const recorderRef = react_1.useRef();
    const [recorder, setRecorderState] = react_1.useState();
    const [isWaiting, setWaiting] = react_1.useState(false);
    const [error, setError] = react_1.useState();
    const [isRecording, setIsRecording] = react_1.useState(false);
    const videoElemRef = react_1.useRef(null);
    const previewRef = react_1.useRef(null);
    const [videoRecordingData, setVideoRecordingData] = react_1.useState((_a = props.data) !== null && _a !== void 0 ? _a : undefined);
    function setRecorder(recorder) {
        setRecorderState(recorder);
        recorderRef.current = recorder;
    }
    function stop() {
        if (videoElemRef.current) {
            videoElemRef.current.pause();
            videoElemRef.current.currentTime = 0;
            videoElemRef.current.onended = null;
        }
    }
    react_1.useEffect(() => {
        var _a;
        stop();
        if (props.data !== (videoRecordingData !== null && videoRecordingData !== void 0 ? videoRecordingData : null)) {
            (_a = props.onChange) === null || _a === void 0 ? void 0 : _a.call(props, videoRecordingData !== null && videoRecordingData !== void 0 ? videoRecordingData : null);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [videoRecordingData]);
    react_1.useEffect(() => {
        var _a, _b;
        if (props.data !== undefined &&
            videoRecordingData !== ((_a = props.data) !== null && _a !== void 0 ? _a : undefined)) {
            setVideoRecordingData((_b = props.data) !== null && _b !== void 0 ? _b : undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [props.data]);
    // useVideoPermissions(setError);
    react_1.useEffect(() => {
        if (error) {
            if (isRecording) {
                recorder === null || recorder === void 0 ? void 0 : recorder.stop();
            }
            setRecorder(undefined);
            setIsRecording(false);
            setVideoRecordingData(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    react_1.useEffect(() => {
        return () => {
            if (recorderRef.current) {
                recorderRef.current.stop();
            }
        };
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, []);
    function onRetryClicked() {
        setError(undefined);
    }
    function onRecordClicked() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            try {
                if (!previewRef.current)
                    return;
                const recorder = yield video_1.getVideoRecorder(previewRef.current);
                setRecorder(recorder);
                recorder.start();
                setIsRecording(true);
                setVideoRecordingData(undefined);
            }
            catch (e) {
                if (e.message.toLowerCase().includes('permission')) {
                    setError(video_1.VideoRecorderError.PERMISSION_DENIED);
                }
                else if (e.message.toLowerCase().includes('device not found')) {
                    setError(video_1.VideoRecorderError.NOT_SUPPORTED);
                }
                else {
                    setError(video_1.VideoRecorderError.UNKNOWN);
                }
            }
            setWaiting(false);
        });
    }
    function onDeleteClicked() {
        setVideoRecordingData(undefined);
    }
    function onStopClicked() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            setWaiting(true);
            if (!recorder) {
                return;
            }
            const recordingData = yield recorder.stop();
            setIsRecording(false);
            setRecorder(undefined);
            setVideoRecordingData(recordingData);
            setWaiting(false);
        });
    }
    const pushNotification = utils_1.useSelector((store) => {
        return store.notificationStore.pushNotification;
    });
    react_1.useEffect(() => {
        if (error !== undefined) {
            let message;
            switch (error) {
                case video_1.VideoRecorderError.NOT_SECURE_CONTEXT:
                    message =
                        'There is no secure context. Need secure context for recording.';
                    break;
                case video_1.VideoRecorderError.NOT_SUPPORTED:
                    message =
                        'Video or audio recording is not supported in this system.' +
                            ' Make sure both camera and mic are attached and are enabled.';
                    break;
                case video_1.VideoRecorderError.PERMISSION_DENIED:
                    message = 'Please provide permission for audio and video recording.';
                    break;
                case video_1.VideoRecorderError.UNKNOWN:
                    message = 'Unexpected error has happened.';
                    break;
            }
            pushNotification({
                message,
                type: NotificationStore_1.NotificationType.ERROR,
            });
            setError(undefined);
        }
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [error]);
    const [secondsCounter, setSecondsCounter] = react_1.useState(0);
    react_1.useEffect(() => {
        if (!isRecording) {
            setSecondsCounter(0);
            return undefined;
        }
        return utils_1.startTimer((time) => {
            setSecondsCounter(Math.floor(time / 1000));
        }, 500);
    }, [isRecording]);
    const hours = Math.floor(secondsCounter / 3600);
    const minutes = Math.floor(secondsCounter / 60) % 60;
    const seconds = secondsCounter % 60;
    return (react_1.default.createElement("div", { className: "flex flex-col items-center justify-center w-full h-full" },
        react_1.default.createElement("span", { className: 'self-start' }, "Video"),
        react_1.default.createElement("div", { className: "flex flex-col gap-4 items-center justify-center" },
            isRecording && (react_1.default.createElement("span", { style: {
                    display: 'inline-block',
                    height: 'auto',
                    width: 'auto',
                    color: undefined,
                } },
                hours > 0 && `${hours.toString().padStart(2, '0')}:`,
                minutes.toString().padStart(2, '0'),
                ":",
                seconds.toString().padStart(2, '0'))),
            react_1.default.createElement("div", { className: `flex items-stretch relative`, style: {
                    height: isRecording ? 220 : 0,
                    width: isRecording ? 400 : 0,
                } },
                react_1.default.createElement("video", { className: "flex-grow min-w-0 min-h-0", ref: previewRef, preload: 'auto', autoPlay: true, muted: true })),
            !videoRecordingData && (react_1.default.createElement(core_1.Button, { variant: 'contained', disabled: isWaiting, onClick: !isRecording ? onRecordClicked : onStopClicked }, !isRecording ? react_1.default.createElement(icons_1.FiberManualRecord, null) : react_1.default.createElement(icons_1.Stop, null))),
            videoRecordingData && (react_1.default.createElement("div", { className: "flex items-stretch relative", style: {
                    width: 400,
                    height: 220,
                } },
                react_1.default.createElement("video", { className: "flex-grow min-w-0", controls: true, preload: "auto", ref: videoElemRef, src: videoRecordingData.videoUrl }),
                react_1.default.createElement("span", { className: "top-0 right-0 absolute" },
                    react_1.default.createElement(core_1.Button, { variant: "contained", onClick: onDeleteClicked },
                        react_1.default.createElement(icons_1.Delete, null))))))));
};
//# sourceMappingURL=VideoRecorder.js.map