"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.useDebouncedValue = void 0;
const react_1 = require("react");
function useDebouncedValue(value, delay) {
    // State and setters for debounced value
    const [debouncedValue, setDebouncedValue] = react_1.useState(value);
    react_1.useEffect(() => {
        // Set debouncedValue to value (passed in) after the specified delay
        const handler = setTimeout(() => {
            setDebouncedValue(value);
        }, delay);
        return () => {
            clearTimeout(handler);
        };
    }, [delay, value]);
    return debouncedValue;
}
exports.useDebouncedValue = useDebouncedValue;
//# sourceMappingURL=useDebouncedValue.js.map