"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MediaType = exports.HoverType = exports.DragDropTypes = exports.ReverseResourceTypeMap = exports.ResourceTypeMap = exports.ResourceType = void 0;
var ResourceType;
(function (ResourceType) {
    ResourceType["VIDEO"] = "Video";
    ResourceType["AUDIO"] = "Audio";
    ResourceType["IMAGE"] = "Image";
})(ResourceType = exports.ResourceType || (exports.ResourceType = {}));
exports.ResourceTypeMap = Object.freeze({
    IMAGE: ResourceType.IMAGE,
    VIDEO: ResourceType.VIDEO,
    AUDIO: ResourceType.AUDIO,
});
exports.ReverseResourceTypeMap = Object.freeze({
    [ResourceType.IMAGE]: 'IMAGE',
    [ResourceType.VIDEO]: 'VIDEO',
    [ResourceType.AUDIO]: 'AUDIO',
});
var DragDropTypes;
(function (DragDropTypes) {
    DragDropTypes["SLIDE"] = "slide";
    DragDropTypes["SLIDE_OPTION"] = "slide_option";
})(DragDropTypes = exports.DragDropTypes || (exports.DragDropTypes = {}));
exports.HoverType = Object.freeze({
    NONE: 'none',
    TOP: 'top',
    BOTTOM: 'bottom',
});
var MediaType;
(function (MediaType) {
    MediaType["VIDEO"] = "VIDEO";
    MediaType["IMAGE"] = "IMAGE";
    MediaType["AUDIO"] = "AUDIO";
})(MediaType = exports.MediaType || (exports.MediaType = {}));
//# sourceMappingURL=CommonEnums.js.map