import { StoreAssociate } from './StoreAssociate';
import { ProductVarient } from './ProductVarient';
import { ProductDTO } from './ProductDTO';
import { CustomerFields } from './CustomerConfig';
export declare enum WishlistType {
    Product = "Product",
    ProductVariant = "ProductVariant"
}
export declare enum ActivityType {
    Placed_order_in_store = "Placed_order_in_store",
    Created_sale_alert = "Created_sale_alert",
    Created_availability_alert = "Created_availability_alert",
    Placed_omnichannel_order = "Placed_omnichannel_order"
}
export interface CustomerTags {
    externalId: string;
    tagName: string;
    businessId: string;
    description: string;
}
export interface CustomerNotes {
    externalId: string;
    note: string;
    createdBy: StoreAssociate;
    lastUpdatedBy?: StoreAssociate;
    updatedAt: Date;
}
export interface CustomerActivity {
    externalId: string;
    activityType?: ActivityType;
    referActivityId?: string;
    created_at: number;
}
export interface CustomerDetails {
    externalId: string;
    contactNumber: string;
    gender: string;
    fullName: string;
    email: string;
    address: string;
    imageUrls: string[];
    videoUrls: string[];
    fullConsumerName: string;
    firstName: string;
    middleName: string;
    lastName: string;
    fullAddress: string;
    addressLine1: string;
    addressLine2: string;
    addressLine3: string;
}
export interface CustomerAttributes {
    externalId: string;
    attributeName: string;
    value: string;
}
export interface Wishlist {
    externalId: string;
    wishlistType: WishlistType;
    productVarient: ProductVarient;
    product: ProductDTO;
}
export interface CustomerFieldValue {
    booleanValue?: boolean;
    categoryValue?: string;
    consumerField: CustomerFields;
    dateTimeValue?: null;
    doubleValue?: null;
    externalId?: string;
    integerValue?: null;
    stringValue?: null;
}
export interface Customer {
    externalId: string;
    contactNumber: string;
    email: string;
    consumerDetails: CustomerDetails;
    tags: CustomerTags[];
    consumerNotes: CustomerNotes[];
    consumerAttributesKVs: CustomerAttributes[];
    consumerFieldValues: CustomerFieldValue[];
    wishlistItems: Wishlist[];
    consumerActivity: CustomerActivity[];
}
