export declare enum FieldType {
    String = "String",
    Integer = "Integer",
    RealNumber = "RealNumber",
    Category = "Category",
    Boolean = "Boolean",
    DateTime = "DateTime"
}
export interface CustomerFields {
    externalId: string;
    field: string;
    fieldType: FieldType;
    isIdentifier: boolean;
    categoryValues: string[];
    consumerWorkflowFields: [];
    isPredefined: boolean;
}
export interface CustomerWorkflowField {
    externalId: string;
    consumerField: CustomerFields;
    isRequired: boolean;
    prevConsumerFieldId?: string;
    nextConsumerFieldId?: string;
}
export interface CustomerConfig {
    externalId: string;
    consumerFields: CustomerFields[];
    nameType?: string;
    addressType?: string;
}
export interface CustomerFieldDTO {
    field: string;
    fieldType: string;
    categoryValues?: string[];
    isIdentifier: boolean;
}
export interface CreateCustomerFieldRequest {
    businessId: string;
    consumerConfigFields: CustomerFieldDTO[];
}
export interface SetPredefinedFieldTypeRequest {
    businessId: string;
    nameType: string;
    addressType: string;
}
export interface CustomerWorkflowConfig {
    externalId: string;
    consumerWorkflowFields: CustomerWorkflowField[];
    isTagVisible: boolean;
    isNoteVisible: boolean;
    isAttributeVisible: boolean;
    isTagEditable: boolean;
    isNoteEditable: boolean;
    isAttributeEditable: boolean;
    isActivityVisible: boolean;
    isWishlistVisible: boolean;
}
export interface WorkFlowConsumerConfigResponse {
    consumerWorkflowConfig: CustomerWorkflowConfig;
    nameType: string;
    addressType: string;
}
export interface WorkFlowConsumerConfigFieldRequest {
    consumerFieldId: string;
    isMandatory: boolean;
    prevConsumerFieldId: string | null;
    nextConsumerFieldId: string | null;
}
export interface WorkFlowConsumerConfigRequest {
    consumerWorkflowFields: WorkFlowConsumerConfigFieldRequest[];
    isTagVisible: boolean;
    isNoteVisible: boolean;
    isAttributeVisible: boolean;
    isTagEditable: boolean;
    isNoteEditable: boolean;
    isAttributeEditable: boolean;
    isActivityVisible: boolean;
    isWishlistVisible: boolean;
}
export interface WorkflowSectionConfig {
    isTagVisible: boolean;
    isNoteVisible: boolean;
    isAttributeVisible: boolean;
    isTagEditable: boolean;
    isNoteEditable: boolean;
    isAttributeEditable: boolean;
    isActivityVisible: boolean;
    isWishlistVisible: boolean;
}
