import { DiscountType, OfferAppliedAt, OfferStatus, OfferType, QualifyingLevelRange } from './enums/OfferEnums';
import { BuyNAndGetMFree, BuyNandGetXPercentOff, BuyOverNAndGetXFree, BuyOverNAndGetXPercentOff, BuyXandGetYAtZPercentOff, DirectPercentageDiscount, DiscountTypeObject } from './DiscountTypeObject';
export interface OfferDTO {
    externalId?: string;
    name: string;
    startDate: string | null;
    endDate: string | null;
    offerType: OfferType;
    offerStatus: OfferStatus;
    offerAppliedAt: OfferAppliedAt;
    businessId: string;
    storeIds?: string[];
    offerAppliedToRange: QualifyingLevelRange;
    offerAppliedToproductBucketId?: string;
    discountAppliedToLevelRange: QualifyingLevelRange;
    discountAppliedToProductBucketId?: string;
    discountType: DiscountType;
    referDiscountObject: DiscountTypeObject;
    totalLimit?: number;
    totalLimitPerCustomer?: number;
    conditional?: string;
}
export interface BuyNAndGetMFreeOffer extends OfferDTO {
    discountType: DiscountType.BUY_N_AND_GET_M_FREE;
    referDiscountObject: BuyNAndGetMFree;
}
export interface BuyNandGetXPercentOffOffer extends OfferDTO {
    discountType: DiscountType.BUY_N_AND_GET_X_PERCENT_OFF;
    referDiscountObject: BuyNandGetXPercentOff;
}
export interface BuyOverNAndGetXFreeOffer extends OfferDTO {
    discountType: DiscountType.BUY_OVER_N_AND_GET_X_FREE;
    referDiscountObject: BuyOverNAndGetXFree;
}
export interface BuyOverNAndGetXPercentOffOffer extends OfferDTO {
    discountType: DiscountType.BUY_OVER_N_AND_GET_X_PERCENT_OFF;
    referDiscountObject: BuyOverNAndGetXPercentOff;
}
export interface BuyXandGetYAtZPercentOffOffer extends OfferDTO {
    discountType: DiscountType.BUY_X_AND_GET_Y_AT_Z_PERCENT_OFF;
    referDiscountObject: BuyXandGetYAtZPercentOff;
}
export interface DirectPercentageDiscountOffer extends OfferDTO {
    discountType: DiscountType.PERCENTAGE_DIRECT;
    referDiscountObject: DirectPercentageDiscount;
}
