"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PaymentMode = exports.PaymentStatus = exports.OrderStatus = exports.OrderType = void 0;
var OrderType;
(function (OrderType) {
    OrderType["CHECKOUT"] = "CHECKOUT";
    OrderType["OMNICHANNEL"] = "OMNICHANNEL";
    OrderType["ONLINE"] = "ONLINE";
})(OrderType = exports.OrderType || (exports.OrderType = {}));
var OrderStatus;
(function (OrderStatus) {
    OrderStatus["CREATED"] = "CREATED";
    OrderStatus["PAYMENT_PENDING"] = "PAYMENT_PENDING";
    OrderStatus["PAYMENT_COMPLETE"] = "PAYMENT_COMPLETE";
    OrderStatus["PROCESSING"] = "PROCESSING";
    OrderStatus["PARTIALLY_FULFILLED"] = "PARTIALLY_FULFILLED";
    OrderStatus["COMPLETED"] = "COMPLETED";
    OrderStatus["ORDER_CANCELLED"] = "ORDER_CANCELLED";
})(OrderStatus = exports.OrderStatus || (exports.OrderStatus = {}));
var PaymentStatus;
(function (PaymentStatus) {
    PaymentStatus["COMPLETED"] = "COMPLETED";
    PaymentStatus["AUTHORIZED"] = "AUTHORIZED";
    PaymentStatus["VOIDED"] = "VOIDED";
    PaymentStatus["REFUNDED"] = "REFUNDED";
    PaymentStatus["CANCELED"] = "CANCELED";
    PaymentStatus["FAILED"] = "FAILED";
    PaymentStatus["HOLD"] = "HOLD";
    PaymentStatus["DECLINED"] = "DECLINED";
    PaymentStatus["READ_CARD_ONLY"] = "READ_CARD_ONLY";
})(PaymentStatus = exports.PaymentStatus || (exports.PaymentStatus = {}));
var PaymentMode;
(function (PaymentMode) {
    PaymentMode["DEBIT_CARD"] = "DEBIT_CARD";
    PaymentMode["CREDIT_CARD"] = "CREDIT_CARD";
    PaymentMode["NO_PAYMENT"] = "NO_PAYMENT";
})(PaymentMode = exports.PaymentMode || (exports.PaymentMode = {}));
//# sourceMappingURL=Order.js.map