import { NodeRepresentation } from './QuestionnaireEnums';
import { BaseNodeContent, LinkNodeContent, WidgetNodeContent } from './NodeContent';
import { Split } from './Split';
import { Threshold } from './Threshold';
export interface BaseNode {
    id: string;
    questionnareId: string;
    actionLinks: Record<string, string | undefined>;
    inLinks: Record<string, string | undefined>;
    outLinks: Record<string, string | undefined>;
    x: number;
    y: number;
    isSkippable: boolean;
    nodeRepresentation: NodeRepresentation;
    nodeContent: BaseNodeContent;
    nodeMetadata?: Record<string, string | undefined>;
    split: Split;
    threshold: Threshold;
    isThresholded: boolean;
}
export interface LinkNode extends BaseNode {
    nodeRepresentation: NodeRepresentation.LINK;
    nodeContent: LinkNodeContent;
}
export interface WidgetNode extends BaseNode {
    nodeRepresentation: NodeRepresentation.NODE;
    nodeContent: WidgetNodeContent;
}
export declare type BackendNode = WidgetNode | LinkNode;
