import { FormItem } from './FormItem';
import { Option } from './Option';
import { ActionType, AllowedResponseType, BodyParamType, FlowType, NodeType, OptionDisplayType, OptionType, PrePopulateAnswerType, QualitativeType, QuestionType, RatingDisplayType, RawBodyParamType, RestVerb, SignatureAllowedResponseType, TextResponseType, UserMediaRecordingType, UXQuestionType, WebAPIType } from './QuestionnaireEnums';
import { QuizData } from './QuizData';
import { ResponseKeyPathContext } from './ResponseKeyPathContext';
export interface BaseNodeContent {
    nodeType: NodeType;
    imageUrl?: string;
    videoUrl?: string;
    id?: string;
    workspaceId: string;
    isFashTagQuestion?: boolean;
    contentVars: string[];
    quizData?: QuizData;
    flowType: FlowType;
    fashtagMetaData?: string;
    isBackNavigationToAllowed?: boolean;
    isBackNavigationFromAllowed?: boolean;
    isPassthroughAllowed?: boolean;
    displayLogic?: string;
    skipLogic?: string;
    sanitizedSkipLogic?: string;
    sanitizedDisplayLogic?: string;
    offendingNodeList?: OffendingNode[];
    offendingWarningNodeList?: OffendingWarningNode[];
    saveToQuestionBank?: boolean;
    customCSS?: string;
}
export interface StatementNodeContent extends BaseNodeContent {
    nodeType: NodeType.STATEMENT;
    content: string;
}
export interface WelcomeNodeContent extends BaseNodeContent {
    nodeType: NodeType.WELCOME;
    content: string;
    description?: string;
    buttonLabel?: string;
}
export interface ThanksNodeContent extends BaseNodeContent {
    nodeType: NodeType.THANKS;
    content: string;
    description?: string;
    buttonLabel?: string;
    isBrandingEnabled?: boolean;
    redirectUrl?: string;
}
export interface QuestionnaireNodeContent extends BaseNodeContent {
    nodeType: NodeType.QUESTIONNARE;
    linkQuestionnareId: string;
}
export interface QuestionBaseNodeContent extends BaseNodeContent {
    nodeType: NodeType.QUESTION;
    content: string;
}
export interface OptionsQuestionNodeContent extends QuestionBaseNodeContent {
    questionType: QuestionType.OPTIONS;
    content: string;
    optionType: OptionType;
    options: Option[];
    optionDisplayType: OptionDisplayType;
    minSelectionsAllowed: number;
    maxSelectionsAllowed: number;
    isOptionHoveringEnabled: boolean;
}
export interface RatingQuestionNodeContent extends QuestionBaseNodeContent {
    questionType: QuestionType.RATING;
    content: string;
    minRating: number;
    maxRating: number;
    stepSize: number;
    leftLabel: string;
    rightLabel: string;
    ratingDisplayType: RatingDisplayType;
}
export interface MatrixQuestionNodeContent extends QuestionBaseNodeContent {
    questionType: QuestionType.MATRIX;
    content: string;
    optionType: OptionType;
    rows: Option[];
    cols: Option[];
    isOptionHoveringEnabled: boolean;
}
export interface TextQuestionNodeContent extends QuestionBaseNodeContent {
    questionType: QuestionType.TEXT;
    allowedResponseTypes: AllowedResponseType[];
    qualitativeType: QualitativeType;
    textResponseType: TextResponseType;
    content: string;
    noOfDigits?: number;
    prePopulateAnswerType: PrePopulateAnswerType;
    prePopulateAnswerValue: string;
}
export interface UXNodeContent extends QuestionBaseNodeContent {
    questionType: QuestionType.UX;
    description: string;
    uxQuestionType: UXQuestionType;
    userMediaRecordingType: UserMediaRecordingType;
}
export interface SignatureNodeContent extends QuestionBaseNodeContent {
    questionType: QuestionType.SIGNATURE;
    signatureAllowedResponseTypes: SignatureAllowedResponseType[];
    description: string;
}
export declare type QuestionNodeContent = RatingQuestionNodeContent | OptionsQuestionNodeContent | TextQuestionNodeContent | MatrixQuestionNodeContent | UXNodeContent | SignatureNodeContent;
export declare enum OffenseType {
    UPDATED = "UPDATED",
    DELETED = "DELETED"
}
export declare enum OffenseEffect {
    FLOW_LOGIC_CONDITION_INVALIDATED = "FLOW_LOGIC_CONDITION_INVALIDATED",
    NODE_DISPLAY_LOGIC_INVALIDATED = "NODE_DISPLAY_LOGIC_INVALIDATED",
    OPTION_DISPLAY_LOGIC_INVALIDATED = "OPTION_DISPLAY_LOGIC_INVALIDATED",
    FORM_DISPLAY_LOGIC_INVALIDATED = "FORM_DISPLAY_LOGIC_INVALIDATED",
    FORM_OPTION_DISPLAY_LOGIC_INVALIDATED = "FORM_OPTION_DISPLAY_LOGIC_INVALIDATED"
}
export interface OffendingNode {
    offenseType: OffenseType;
    nodeId: string;
    questionType?: QuestionType;
    optionType?: OptionType;
    content: string;
    nodeType: NodeType;
    offenseEffect: OffenseEffect;
}
export interface OffendingWarningNode {
    offenseType: OffenseType;
    nodeId: string;
    questionType?: QuestionType;
    optionType?: OptionType;
    content: string;
    nodeType: NodeType;
    offenseEffect: OffenseEffect;
}
export interface ConditionalNodeContent extends BaseNodeContent {
    nodeType: NodeType.CONDITIONAL;
    content: string;
}
export interface ElseNodeContent extends BaseNodeContent {
    nodeType: NodeType.ELSE_CONDITIONAL;
    content: undefined;
}
export interface ActionBaseNodeContent extends BaseNodeContent {
    title: string;
    nodeType: NodeType.ACTION;
    actionType: ActionType;
}
export interface WebActionNodeContent extends ActionBaseNodeContent {
    actionType: ActionType.WEB_ACTION;
    webAPIType: WebAPIType;
    restVerb: RestVerb;
    url: string;
    headers?: Record<string, string | undefined>;
    queryParams?: Record<string, string | undefined>;
    bodyParams?: string;
    bodyParamKeyValue?: Record<string, string | undefined>;
    isFireAndForget: boolean;
    responseKeyContextMap: ResponseKeyPathContext[];
    isGraphQL: boolean;
    bodyParamType: BodyParamType;
    rawBodyParamType: RawBodyParamType;
}
export interface EmailActionNodeContent extends ActionBaseNodeContent {
    actionType: ActionType.EMAIL;
    receiversEmailAddress?: string;
    subjectLine?: string;
    emailContent?: string;
}
export interface SMSActionNodeContent extends ActionBaseNodeContent {
    actionType: ActionType.SMS;
    receiversPhoneNumber?: string;
    smsContent?: string;
}
export interface FormNodeContent extends BaseNodeContent {
    nodeType: NodeType.FORM;
    title: string;
    actionText: string;
    formItems: FormItem[];
}
export declare type ActionNodeContent = WebActionNodeContent | EmailActionNodeContent | SMSActionNodeContent;
export declare type ContentNodeContent = StatementNodeContent | QuestionNodeContent;
export declare type WidgetNodeContent = ContentNodeContent | QuestionnaireNodeContent | ConditionalNodeContent | ElseNodeContent | ActionNodeContent | FormNodeContent | ThanksNodeContent | WelcomeNodeContent;
export declare type LinkNodeContent = ConditionalNodeContent;
export declare type NodeContent = WidgetNodeContent | LinkNodeContent;
