export declare enum FlowType {
    QUESTIONNAIRE = "QUESTIONNAIRE",
    QUIZ = "QUIZ",
    SURVEY = "SURVEY"
}
export declare enum NodeType {
    QUESTION = "QUESTION",
    CONDITIONAL = "CONDITIONAL",
    QUESTIONNARE = "QUESTIONNARE",
    ELSE_CONDITIONAL = "ELSE_CONDITIONAL",
    STATEMENT = "STATEMENT",
    ACTION = "ACTION",
    FORM = "FORM",
    WELCOME = "WELCOME",
    THANKS = "THANKS"
}
export declare enum ActionType {
    WEB_ACTION = "WEB_ACTION",
    EMAIL = "EMAIL",
    SMS = "SMS"
}
export declare enum NodeRepresentation {
    LINK = "LINK",
    NODE = "NODE"
}
export declare enum SplitType {
    RANDOM = "RANDOM",
    PERCENTAGE = "PERCENTAGE"
}
export declare enum ThresholdType {
    IMPRESSION = "IMPRESSION",
    RESPONSE = "RESPONSE"
}
export declare enum VariableType {
    DOUBLE = "DOUBLE",
    LIST_DOUBLE = "LIST_DOUBLE",
    STRING = "STRING",
    LIST_STRING = "LIST_STRING"
}
export declare enum RatingDisplayType {
    NUMERIC = "NUMERIC",
    THUMBS_UP = "THUMBS_UP",
    PEOPLE = "PEOPLE",
    LIGHTNING = "LIGHTNING",
    STARS = "STARS"
}
/**
 * Type of link described in link meta data
 */
export declare enum LinkType {
    /**
     * For unconditional links
     */
    NORMAL = "NORMAL",
    /**
     * For conditional links where one selection is allowed
     * Possible use cases: SingleSelect, Rating and MultiSelect in QUIZ
     */
    SINGLE = "SINGLE",
    /**
     * For conditional links where multiple selections are allowed
     * Possible use cases: MultiSelect in QUESTIONNAIRE and SURVEY
     */
    MULTIPLE = "MULTIPLE"
}
export declare enum QuestionType {
    OPTIONS = "OPTIONS",
    RATING = "RATING",
    TEXT = "TEXT",
    MATRIX = "MATRIX",
    UX = "UX",
    SIGNATURE = "SIGNATURE"
}
export declare enum OptionType {
    SINGLE = "SINGLE",
    MULTIPLE = "MULTIPLE",
    RANKING = "RANKING"
}
export declare enum OptionDisplayType {
    VERTICAL = "VERTICAL",
    DROPDOWN = "DROPDOWN"
}
export declare enum SessionStatus {
    CREATED = "CREATED",
    IN_PROGRESS = "IN_PROGRESS",
    COMPLETED = "COMPLETED"
}
export declare enum EvalStatus {
    IN_PROGRESS = "IN_PROGRESS",
    IN_PROGRESS_WITH_SUBJECTIVE = "IN_PROGRESS_WITH_SUBJECTIVE",
    PARTIALLY_COMPLETED = "PARTIALLY_COMPLETED",
    COMPLETED = "COMPLETED"
}
export declare enum AllowedResponseType {
    TEXT_RESPONSE = "TEXT_RESPONSE",
    IMAGE_RESPONSE = "IMAGE_RESPONSE",
    AUDIO_RESPONSE = "AUDIO_RESPONSE",
    VIDEO_RESPONSE = "VIDEO_RESPONSE",
    DATE_RESPONSE = "DATE_RESPONSE",
    TIME_RESPONSE = "TIME_RESPONSE"
}
export declare enum UXQuestionType {
    FEEDBACK_WITH_CONTEXT = "FEEDBACK_WITH_CONTEXT",
    SCREEN_SHOT = "SCREEN_SHOT",
    RECORD_SCREEN = "RECORD_SCREEN"
}
export declare enum SignatureAllowedResponseType {
    DRAW = "DRAW",
    TYPE = "TYPE",
    UPLOAD = "UPLOAD"
}
export declare enum WebAPIType {
    REST = "REST",
    SOAP = "SOAP",
    GRAPH_QL = "GRAPHQL"
}
export declare enum RestVerb {
    GET = "GET",
    POST = "POST",
    PUT = "PUT",
    DELETE = "DELETE",
    PATCH = "PATCH"
}
export declare enum BodyParamType {
    NONE = "NONE",
    FORM_DATA = "FORM_DATA",
    X_WWW_FORM_URLENCODED = "X_WWW_FORM_URLENCODED",
    RAW = "RAW"
}
export declare enum RawBodyParamType {
    TEXT = "TEXT",
    JAVASCRIPT = "JAVASCRIPT",
    JSON = "JSON",
    HTML = "HTML",
    XML = "XML"
}
export declare enum QualitativeType {
    NORMAL = "NORMAL",
    PHONE = "PHONE",
    EMAIL = "EMAIL",
    UPLOAD = "UPLOAD",
    URL = "URL",
    NUMERIC = "NUMERIC"
}
export declare enum TextResponseType {
    SINGLE_LINE = "SINGLE_LINE",
    MULTI_LINE = "MULTI_LINE"
}
export declare enum PrePopulateAnswerType {
    NONE = "NONE",
    CONSTANT = "CONSTANT",
    VARIABLE = "VARIABLE"
}
export declare enum UserMediaRecordingType {
    NONE = "NONE",
    AUDIO = "AUDIO",
    AUDIO_VIDEO = "AUDIO_VIDEO"
}
