"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserMediaRecordingType = exports.PrePopulateAnswerType = exports.TextResponseType = exports.QualitativeType = exports.RawBodyParamType = exports.BodyParamType = exports.RestVerb = exports.WebAPIType = exports.SignatureAllowedResponseType = exports.UXQuestionType = exports.AllowedResponseType = exports.EvalStatus = exports.SessionStatus = exports.OptionDisplayType = exports.OptionType = exports.QuestionType = exports.LinkType = exports.RatingDisplayType = exports.VariableType = exports.ThresholdType = exports.SplitType = exports.NodeRepresentation = exports.ActionType = exports.NodeType = exports.FlowType = void 0;
var FlowType;
(function (FlowType) {
    FlowType["QUESTIONNAIRE"] = "QUESTIONNAIRE";
    FlowType["QUIZ"] = "QUIZ";
    FlowType["SURVEY"] = "SURVEY";
})(FlowType = exports.FlowType || (exports.FlowType = {}));
var NodeType;
(function (NodeType) {
    NodeType["QUESTION"] = "QUESTION";
    NodeType["CONDITIONAL"] = "CONDITIONAL";
    NodeType["QUESTIONNARE"] = "QUESTIONNARE";
    NodeType["ELSE_CONDITIONAL"] = "ELSE_CONDITIONAL";
    NodeType["STATEMENT"] = "STATEMENT";
    NodeType["ACTION"] = "ACTION";
    NodeType["FORM"] = "FORM";
    NodeType["WELCOME"] = "WELCOME";
    NodeType["THANKS"] = "THANKS";
})(NodeType = exports.NodeType || (exports.NodeType = {}));
var ActionType;
(function (ActionType) {
    ActionType["WEB_ACTION"] = "WEB_ACTION";
    ActionType["EMAIL"] = "EMAIL";
    ActionType["SMS"] = "SMS";
})(ActionType = exports.ActionType || (exports.ActionType = {}));
var NodeRepresentation;
(function (NodeRepresentation) {
    NodeRepresentation["LINK"] = "LINK";
    NodeRepresentation["NODE"] = "NODE";
})(NodeRepresentation = exports.NodeRepresentation || (exports.NodeRepresentation = {}));
var SplitType;
(function (SplitType) {
    SplitType["RANDOM"] = "RANDOM";
    SplitType["PERCENTAGE"] = "PERCENTAGE";
})(SplitType = exports.SplitType || (exports.SplitType = {}));
var ThresholdType;
(function (ThresholdType) {
    ThresholdType["IMPRESSION"] = "IMPRESSION";
    ThresholdType["RESPONSE"] = "RESPONSE";
})(ThresholdType = exports.ThresholdType || (exports.ThresholdType = {}));
var VariableType;
(function (VariableType) {
    VariableType["DOUBLE"] = "DOUBLE";
    VariableType["LIST_DOUBLE"] = "LIST_DOUBLE";
    VariableType["STRING"] = "STRING";
    VariableType["LIST_STRING"] = "LIST_STRING";
})(VariableType = exports.VariableType || (exports.VariableType = {}));
var RatingDisplayType;
(function (RatingDisplayType) {
    RatingDisplayType["NUMERIC"] = "NUMERIC";
    RatingDisplayType["THUMBS_UP"] = "THUMBS_UP";
    RatingDisplayType["PEOPLE"] = "PEOPLE";
    RatingDisplayType["LIGHTNING"] = "LIGHTNING";
    RatingDisplayType["STARS"] = "STARS";
})(RatingDisplayType = exports.RatingDisplayType || (exports.RatingDisplayType = {}));
/**
 * Type of link described in link meta data
 */
var LinkType;
(function (LinkType) {
    /**
     * For unconditional links
     */
    LinkType["NORMAL"] = "NORMAL";
    /**
     * For conditional links where one selection is allowed
     * Possible use cases: SingleSelect, Rating and MultiSelect in QUIZ
     */
    LinkType["SINGLE"] = "SINGLE";
    /**
     * For conditional links where multiple selections are allowed
     * Possible use cases: MultiSelect in QUESTIONNAIRE and SURVEY
     */
    LinkType["MULTIPLE"] = "MULTIPLE";
})(LinkType = exports.LinkType || (exports.LinkType = {}));
var QuestionType;
(function (QuestionType) {
    QuestionType["OPTIONS"] = "OPTIONS";
    QuestionType["RATING"] = "RATING";
    QuestionType["TEXT"] = "TEXT";
    QuestionType["MATRIX"] = "MATRIX";
    QuestionType["UX"] = "UX";
    QuestionType["SIGNATURE"] = "SIGNATURE";
})(QuestionType = exports.QuestionType || (exports.QuestionType = {}));
var OptionType;
(function (OptionType) {
    OptionType["SINGLE"] = "SINGLE";
    OptionType["MULTIPLE"] = "MULTIPLE";
    OptionType["RANKING"] = "RANKING";
})(OptionType = exports.OptionType || (exports.OptionType = {}));
var OptionDisplayType;
(function (OptionDisplayType) {
    OptionDisplayType["VERTICAL"] = "VERTICAL";
    OptionDisplayType["DROPDOWN"] = "DROPDOWN";
})(OptionDisplayType = exports.OptionDisplayType || (exports.OptionDisplayType = {}));
var SessionStatus;
(function (SessionStatus) {
    SessionStatus["CREATED"] = "CREATED";
    SessionStatus["IN_PROGRESS"] = "IN_PROGRESS";
    SessionStatus["COMPLETED"] = "COMPLETED";
})(SessionStatus = exports.SessionStatus || (exports.SessionStatus = {}));
var EvalStatus;
(function (EvalStatus) {
    EvalStatus["IN_PROGRESS"] = "IN_PROGRESS";
    EvalStatus["IN_PROGRESS_WITH_SUBJECTIVE"] = "IN_PROGRESS_WITH_SUBJECTIVE";
    EvalStatus["PARTIALLY_COMPLETED"] = "PARTIALLY_COMPLETED";
    EvalStatus["COMPLETED"] = "COMPLETED";
})(EvalStatus = exports.EvalStatus || (exports.EvalStatus = {}));
var AllowedResponseType;
(function (AllowedResponseType) {
    AllowedResponseType["TEXT_RESPONSE"] = "TEXT_RESPONSE";
    AllowedResponseType["IMAGE_RESPONSE"] = "IMAGE_RESPONSE";
    AllowedResponseType["AUDIO_RESPONSE"] = "AUDIO_RESPONSE";
    AllowedResponseType["VIDEO_RESPONSE"] = "VIDEO_RESPONSE";
    AllowedResponseType["DATE_RESPONSE"] = "DATE_RESPONSE";
    AllowedResponseType["TIME_RESPONSE"] = "TIME_RESPONSE";
})(AllowedResponseType = exports.AllowedResponseType || (exports.AllowedResponseType = {}));
var UXQuestionType;
(function (UXQuestionType) {
    UXQuestionType["FEEDBACK_WITH_CONTEXT"] = "FEEDBACK_WITH_CONTEXT";
    UXQuestionType["SCREEN_SHOT"] = "SCREEN_SHOT";
    UXQuestionType["RECORD_SCREEN"] = "RECORD_SCREEN";
})(UXQuestionType = exports.UXQuestionType || (exports.UXQuestionType = {}));
var SignatureAllowedResponseType;
(function (SignatureAllowedResponseType) {
    SignatureAllowedResponseType["DRAW"] = "DRAW";
    SignatureAllowedResponseType["TYPE"] = "TYPE";
    SignatureAllowedResponseType["UPLOAD"] = "UPLOAD";
})(SignatureAllowedResponseType = exports.SignatureAllowedResponseType || (exports.SignatureAllowedResponseType = {}));
var WebAPIType;
(function (WebAPIType) {
    WebAPIType["REST"] = "REST";
    WebAPIType["SOAP"] = "SOAP";
    WebAPIType["GRAPH_QL"] = "GRAPHQL";
})(WebAPIType = exports.WebAPIType || (exports.WebAPIType = {}));
var RestVerb;
(function (RestVerb) {
    RestVerb["GET"] = "GET";
    RestVerb["POST"] = "POST";
    RestVerb["PUT"] = "PUT";
    RestVerb["DELETE"] = "DELETE";
    RestVerb["PATCH"] = "PATCH";
})(RestVerb = exports.RestVerb || (exports.RestVerb = {}));
var BodyParamType;
(function (BodyParamType) {
    BodyParamType["NONE"] = "NONE";
    BodyParamType["FORM_DATA"] = "FORM_DATA";
    BodyParamType["X_WWW_FORM_URLENCODED"] = "X_WWW_FORM_URLENCODED";
    BodyParamType["RAW"] = "RAW";
})(BodyParamType = exports.BodyParamType || (exports.BodyParamType = {}));
var RawBodyParamType;
(function (RawBodyParamType) {
    RawBodyParamType["TEXT"] = "TEXT";
    RawBodyParamType["JAVASCRIPT"] = "JAVASCRIPT";
    RawBodyParamType["JSON"] = "JSON";
    RawBodyParamType["HTML"] = "HTML";
    RawBodyParamType["XML"] = "XML";
})(RawBodyParamType = exports.RawBodyParamType || (exports.RawBodyParamType = {}));
var QualitativeType;
(function (QualitativeType) {
    QualitativeType["NORMAL"] = "NORMAL";
    QualitativeType["PHONE"] = "PHONE";
    QualitativeType["EMAIL"] = "EMAIL";
    QualitativeType["UPLOAD"] = "UPLOAD";
    QualitativeType["URL"] = "URL";
    QualitativeType["NUMERIC"] = "NUMERIC";
})(QualitativeType = exports.QualitativeType || (exports.QualitativeType = {}));
var TextResponseType;
(function (TextResponseType) {
    TextResponseType["SINGLE_LINE"] = "SINGLE_LINE";
    TextResponseType["MULTI_LINE"] = "MULTI_LINE";
})(TextResponseType = exports.TextResponseType || (exports.TextResponseType = {}));
var PrePopulateAnswerType;
(function (PrePopulateAnswerType) {
    PrePopulateAnswerType["NONE"] = "NONE";
    PrePopulateAnswerType["CONSTANT"] = "CONSTANT";
    PrePopulateAnswerType["VARIABLE"] = "VARIABLE";
})(PrePopulateAnswerType = exports.PrePopulateAnswerType || (exports.PrePopulateAnswerType = {}));
var UserMediaRecordingType;
(function (UserMediaRecordingType) {
    UserMediaRecordingType["NONE"] = "NONE";
    UserMediaRecordingType["AUDIO"] = "AUDIO";
    UserMediaRecordingType["AUDIO_VIDEO"] = "AUDIO_VIDEO";
})(UserMediaRecordingType = exports.UserMediaRecordingType || (exports.UserMediaRecordingType = {}));
//# sourceMappingURL=QuestionnaireEnums.js.map